<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Change default size for single image shortcode
add_action('init', 'vc_update_defaults', 100);
function vc_update_defaults() {
	if ( class_exists( 'WPBMap' ) )  {
		// Set full size for single image by default
		$param = WPBMap::getParam( 'vc_single_image', 'img_size' );
		$param['value'] = 'full';
		vc_update_shortcode_param( 'vc_single_image', $param );
	}
}

// Add moreparams
add_action('init', 'vc_add_new_para', 100);
	function vc_add_new_para() {
	if ( function_exists( 'add_shortcode_param' ) ) {
		if ( defined( 'WPB_VC_VERSION' ) && version_compare( '5.0', WPB_VC_VERSION, '>=' ) ) {
			add_shortcode_param( 'number' , 'startflow_param_number' );
			add_shortcode_param( 'headings' , 'startflow_param_heading' );
		}
	}
	if ( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'number' , 'startflow_param_number' );
		vc_add_shortcode_param( 'headings' , 'startflow_param_heading' );
	}

	// Add Number param
	function startflow_param_number( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$type = isset($settings['type']) ? $settings['type'] : '';
		$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$output = '<input type="number" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="'. $value.'" style="max-width:100px; margin-right: 10px;" />'. $suffix;
		return $output;
	}

	// Add Heading param
	function startflow_param_heading( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$text = isset($settings['text']) ? $settings['text'] : '';
		$output = '<h4 '. $dependency .' class="wpb_vc_param_value '. $class .'" style="margin: 10px 0 0;padding:10px;font-size:14px; background:#ebebeb;color:#666;">'. $text .'</h4>';
		$output .= '<input type="hidden" name="'. $settings['param_name'].'" class="wpb_vc_param_value '. $settings['param_name'] .' '. $settings['type'] .'_field" value="'. $value.'" '. $dependency.'/>';
		return $output;
	}
}

// Register CSS Icons Styles
add_action( 'vc_base_register_admin_css', 'extra_vc_iconpicker_base_register_css' );
function extra_vc_iconpicker_base_register_css(){
    wp_enqueue_style('extraicon', plugin_dir_url( __FILE__ ) . '/assets/eleganticons.css');
    wp_enqueue_style('extraicon2', plugin_dir_url( __FILE__ ) . '/assets/pe-icon-7-stroke.css');
}

// Define the Icons for VC Iconpicker
add_filter( 'vc_iconpicker-type-extraicon', 'vc_iconpicker_type_extraicon' );
function vc_iconpicker_type_extraicon() {
    return array(
		array("elegant-arrow_up" => "elegant-arrow_up"),
		array("elegant-arrow_down" => "elegant-arrow_down"),
		array("elegant-arrow_left" => "elegant-arrow_left"),
		array("elegant-arrow_right" => "elegant-arrow_right"),
		array("elegant-arrow_left-up" => "elegant-arrow_left-up"),
		array("elegant-arrow_right-up" => "elegant-arrow_right-up"),
		array("elegant-arrow_right-down" => "elegant-arrow_right-down"),
		array("elegant-arrow_left-down" => "elegant-arrow_left-down"),
		array("elegant-arrow-up-down" => "elegant-arrow-up-down"),
		array("elegant-arrow_up-down_alt" => "elegant-arrow_up-down_alt"),
		array("elegant-arrow_left-right_alt" => "elegant-arrow_left-right_alt"),
		array("elegant-arrow_left-right" => "elegant-arrow_left-right"),
		array("elegant-arrow_expand_alt2" => "elegant-arrow_expand_alt2"),
		array("elegant-arrow_expand_alt" => "elegant-arrow_expand_alt"),
		array("elegant-arrow_condense" => "elegant-arrow_condense"),
		array("elegant-arrow_expand" => "elegant-arrow_expand"),
		array("elegant-arrow_move" => "elegant-arrow_move"),
		array("elegant-arrow_carrot-up" => "elegant-arrow_carrot-up"),
		array("elegant-arrow_carrot-down" => "elegant-arrow_carrot-down"),
		array("elegant-arrow_carrot-left" => "elegant-arrow_carrot-left"),
		array("elegant-arrow_carrot-right" => "elegant-arrow_carrot-right"),
		array("elegant-arrow_carrot-2up" => "elegant-arrow_carrot-2up"),
		array("elegant-arrow_carrot-2down" => "elegant-arrow_carrot-2down"),
		array("elegant-arrow_carrot-2left" => "elegant-arrow_carrot-2left"),
		array("elegant-arrow_carrot-2right" => "elegant-arrow_carrot-2right"),
		array("elegant-arrow_carrot-up_alt2" => "elegant-arrow_carrot-up_alt2"),
		array("elegant-arrow_carrot-down_alt2" => "elegant-arrow_carrot-down_alt2"),
		array("elegant-arrow_carrot-left_alt2" => "elegant-arrow_carrot-left_alt2"),
		array("elegant-arrow_carrot-right_alt2" => "elegant-arrow_carrot-right_alt2"),
		array("elegant-arrow_carrot-2up_alt2" => "elegant-arrow_carrot-2up_alt2"),
		array("elegant-arrow_carrot-2down_alt2" => "elegant-arrow_carrot-2down_alt2"),
		array("elegant-arrow_carrot-2left_alt2" => "elegant-arrow_carrot-2left_alt2"),
		array("elegant-arrow_carrot-2right_alt2" => "elegant-arrow_carrot-2right_alt2"),
		array("elegant-arrow_triangle-up" => "elegant-arrow_triangle-up"),
		array("elegant-arrow_triangle-down" => "elegant-arrow_triangle-down"),
		array("elegant-arrow_triangle-left" => "elegant-arrow_triangle-left"),
		array("elegant-arrow_triangle-right" => "elegant-arrow_triangle-right"),
		array("elegant-arrow_triangle-up_alt2" => "elegant-arrow_triangle-up_alt2"),
		array("elegant-arrow_triangle-down_alt2" => "elegant-arrow_triangle-down_alt2"),
		array("elegant-arrow_triangle-left_alt2" => "elegant-arrow_triangle-left_alt2"),
		array("elegant-arrow_triangle-right_alt2" => "elegant-arrow_triangle-right_alt2"),
		array("elegant-arrow_back" => "elegant-arrow_back"),
		array("elegant-icon_minus-06" => "elegant-icon_minus-06"),
		array("elegant-icon_plus" => "elegant-icon_plus"),
		array("elegant-icon_close" => "elegant-icon_close"),
		array("elegant-icon_check" => "elegant-icon_check"),
		array("elegant-icon_minus_alt2" => "elegant-icon_minus_alt2"),
		array("elegant-icon_plus_alt2" => "elegant-icon_plus_alt2"),
		array("elegant-icon_close_alt2" => "elegant-icon_close_alt2"),
		array("elegant-icon_check_alt2" => "elegant-icon_check_alt2"),
		array("elegant-icon_zoom-out_alt" => "elegant-icon_zoom-out_alt"),
		array("elegant-icon_zoom-in_alt" => "elegant-icon_zoom-in_alt"),
		array("elegant-icon_search" => "elegant-icon_search"),
		array("elegant-icon_box-empty" => "elegant-icon_box-empty"),
		array("elegant-icon_box-selected" => "elegant-icon_box-selected"),
		array("elegant-icon_minus-box" => "elegant-icon_minus-box"),
		array("elegant-icon_plus-box" => "elegant-icon_plus-box"),
		array("elegant-icon_box-checked" => "elegant-icon_box-checked"),
		array("elegant-icon_circle-empty" => "elegant-icon_circle-empty"),
		array("elegant-icon_circle-slelected" => "elegant-icon_circle-slelected"),
		array("elegant-icon_stop_alt2" => "elegant-icon_stop_alt2"),
		array("elegant-icon_stop" => "elegant-icon_stop"),
		array("elegant-icon_pause_alt2" => "elegant-icon_pause_alt2"),
		array("elegant-icon_pause" => "elegant-icon_pause"),
		array("elegant-icon_menu" => "elegant-icon_menu"),
		array("elegant-icon_menu-square_alt2" => "elegant-icon_menu-square_alt2"),
		array("elegant-icon_menu-circle_alt2" => "elegant-icon_menu-circle_alt2"),
		array("elegant-icon_ul" => "elegant-icon_ul"),
		array("elegant-icon_ol" => "elegant-icon_ol"),
		array("elegant-icon_adjust-horiz" => "elegant-icon_adjust-horiz"),
		array("elegant-icon_adjust-vert" => "elegant-icon_adjust-vert"),
		array("elegant-icon_document_alt" => "elegant-icon_document_alt"),
		array("elegant-icon_documents_alt" => "elegant-icon_documents_alt"),
		array("elegant-icon_pencil" => "elegant-icon_pencil"),
		array("elegant-icon_pencil-edit_alt" => "elegant-icon_pencil-edit_alt"),
		array("elegant-icon_pencil-edit" => "elegant-icon_pencil-edit"),
		array("elegant-icon_folder-alt" => "elegant-icon_folder-alt"),
		array("elegant-icon_folder-open_alt" => "elegant-icon_folder-open_alt"),
		array("elegant-icon_folder-add_alt" => "elegant-icon_folder-add_alt"),
		array("elegant-icon_info_alt" => "elegant-icon_info_alt"),
		array("elegant-icon_error-oct_alt" => "elegant-icon_error-oct_alt"),
		array("elegant-icon_error-circle_alt" => "elegant-icon_error-circle_alt"),
		array("elegant-icon_error-triangle_alt" => "elegant-icon_error-triangle_alt"),
		array("elegant-icon_question_alt2" => "elegant-icon_question_alt2"),
		array("elegant-icon_question" => "elegant-icon_question"),
		array("elegant-icon_comment_alt" => "elegant-icon_comment_alt"),
		array("elegant-icon_chat_alt" => "elegant-icon_chat_alt"),
		array("elegant-icon_vol-mute_alt" => "elegant-icon_vol-mute_alt"),
		array("elegant-icon_volume-low_alt" => "elegant-icon_volume-low_alt"),
		array("elegant-icon_volume-high_alt" => "elegant-icon_volume-high_alt"),
		array("elegant-icon_quotations" => "elegant-icon_quotations"),
		array("elegant-icon_quotations_alt2" => "elegant-icon_quotations_alt2"),
		array("elegant-icon_clock_alt" => "elegant-icon_clock_alt"),
		array("elegant-icon_lock_alt" => "elegant-icon_lock_alt"),
		array("elegant-icon_lock-open_alt" => "elegant-icon_lock-open_alt"),
		array("elegant-icon_key_alt" => "elegant-icon_key_alt"),
		array("elegant-icon_cloud_alt" => "elegant-icon_cloud_alt"),
		array("elegant-icon_cloud-upload_alt" => "elegant-icon_cloud-upload_alt"),
		array("elegant-icon_cloud-download_alt" => "elegant-icon_cloud-download_alt"),
		array("elegant-icon_image" => "elegant-icon_image"),
		array("elegant-icon_images" => "elegant-icon_images"),
		array("elegant-icon_lightbulb_alt" => "elegant-icon_lightbulb_alt"),
		array("elegant-icon_gift_alt" => "elegant-icon_gift_alt"),
		array("elegant-icon_house_alt" => "elegant-icon_house_alt"),
		array("elegant-icon_genius" => "elegant-icon_genius"),
		array("elegant-icon_mobile" => "elegant-icon_mobile"),
		array("elegant-icon_tablet" => "elegant-icon_tablet"),
		array("elegant-icon_laptop" => "elegant-icon_laptop"),
		array("elegant-icon_desktop" => "elegant-icon_desktop"),
		array("elegant-icon_camera_alt" => "elegant-icon_camera_alt"),
		array("elegant-icon_mail_alt" => "elegant-icon_mail_alt"),
		array("elegant-icon_cone_alt" => "elegant-icon_cone_alt"),
		array("elegant-icon_ribbon_alt" => "elegant-icon_ribbon_alt"),
		array("elegant-icon_bag_alt" => "elegant-icon_bag_alt"),
		array("elegant-icon_creditcard" => "elegant-icon_creditcard"),
		array("elegant-icon_cart_alt" => "elegant-icon_cart_alt"),
		array("elegant-icon_paperclip" => "elegant-icon_paperclip"),
		array("elegant-icon_tag_alt" => "elegant-icon_tag_alt"),
		array("elegant-icon_tags_alt" => "elegant-icon_tags_alt"),
		array("elegant-icon_trash_alt" => "elegant-icon_trash_alt"),
		array("elegant-icon_cursor_alt" => "elegant-icon_cursor_alt"),
		array("elegant-icon_mic_alt" => "elegant-icon_mic_alt"),
		array("elegant-icon_compass_alt" => "elegant-icon_compass_alt"),
		array("elegant-icon_pin_alt" => "elegant-icon_pin_alt"),
		array("elegant-icon_pushpin_alt" => "elegant-icon_pushpin_alt"),
		array("elegant-icon_map_alt" => "elegant-icon_map_alt"),
		array("elegant-icon_drawer_alt" => "elegant-icon_drawer_alt"),
		array("elegant-icon_toolbox_alt" => "elegant-icon_toolbox_alt"),
		array("elegant-icon_book_alt" => "elegant-icon_book_alt"),
		array("elegant-icon_calendar" => "elegant-icon_calendar"),
		array("elegant-icon_film" => "elegant-icon_film"),
		array("elegant-icon_table" => "elegant-icon_table"),
		array("elegant-icon_contacts_alt" => "elegant-icon_contacts_alt"),
		array("elegant-icon_headphones" => "elegant-icon_headphones"),
		array("elegant-icon_lifesaver" => "elegant-icon_lifesaver"),
		array("elegant-icon_piechart" => "elegant-icon_piechart"),
		array("elegant-icon_refresh" => "elegant-icon_refresh"),
		array("elegant-icon_link_alt" => "elegant-icon_link_alt"),
		array("elegant-icon_link" => "elegant-icon_link"),
		array("elegant-icon_loading" => "elegant-icon_loading"),
		array("elegant-icon_blocked" => "elegant-icon_blocked"),
		array("elegant-icon_archive_alt" => "elegant-icon_archive_alt"),
		array("elegant-icon_heart_alt" => "elegant-icon_heart_alt"),
		array("elegant-icon_star_alt" => "elegant-icon_star_alt"),
		array("elegant-icon_star-half_alt" => "elegant-icon_star-half_alt"),
		array("elegant-icon_star" => "elegant-icon_star"),
		array("elegant-icon_star-half" => "elegant-icon_star-half"),
		array("elegant-icon_tools" => "elegant-icon_tools"),
		array("elegant-icon_tool" => "elegant-icon_tool"),
		array("elegant-icon_cog" => "elegant-icon_cog"),
		array("elegant-icon_cogs" => "elegant-icon_cogs"),
		array("elegant-arrow_up_alt" => "elegant-arrow_up_alt"),
		array("elegant-arrow_down_alt" => "elegant-arrow_down_alt"),
		array("elegant-arrow_left_alt" => "elegant-arrow_left_alt"),
		array("elegant-arrow_right_alt" => "elegant-arrow_right_alt"),
		array("elegant-arrow_left-up_alt" => "elegant-arrow_left-up_alt"),
		array("elegant-arrow_right-up_alt" => "elegant-arrow_right-up_alt"),
		array("elegant-arrow_right-down_alt" => "elegant-arrow_right-down_alt"),
		array("elegant-arrow_left-down_alt" => "elegant-arrow_left-down_alt"),
		array("elegant-arrow_condense_alt" => "elegant-arrow_condense_alt"),
		array("elegant-arrow_expand_alt3" => "elegant-arrow_expand_alt3"),
		array("elegant-arrow_carrot_up_alt" => "elegant-arrow_carrot_up_alt"),
		array("elegant-arrow_carrot-down_alt" => "elegant-arrow_carrot-down_alt"),
		array("elegant-arrow_carrot-left_alt" => "elegant-arrow_carrot-left_alt"),
		array("elegant-arrow_carrot-right_alt" => "elegant-arrow_carrot-right_alt"),
		array("elegant-arrow_carrot-2up_alt" => "elegant-arrow_carrot-2up_alt"),
		array("elegant-arrow_carrot-2dwnn_alt" => "elegant-arrow_carrot-2dwnn_alt"),
		array("elegant-arrow_carrot-2left_alt" => "elegant-arrow_carrot-2left_alt"),
		array("elegant-arrow_carrot-2right_alt" => "elegant-arrow_carrot-2right_alt"),
		array("elegant-arrow_triangle-up_alt" => "elegant-arrow_triangle-up_alt"),
		array("elegant-arrow_triangle-down_alt" => "elegant-arrow_triangle-down_alt"),
		array("elegant-arrow_triangle-left_alt" => "elegant-arrow_triangle-left_alt"),
		array("elegant-arrow_triangle-right_alt" => "elegant-arrow_triangle-right_alt"),
		array("elegant-icon_minus_alt" => "elegant-icon_minus_alt"),
		array("elegant-icon_plus_alt" => "elegant-icon_plus_alt"),
		array("elegant-icon_close_alt" => "elegant-icon_close_alt"),
		array("elegant-icon_check_alt" => "elegant-icon_check_alt"),
		array("elegant-icon_zoom-out" => "elegant-icon_zoom-out"),
		array("elegant-icon_zoom-in" => "elegant-icon_zoom-in"),
		array("elegant-icon_stop_alt" => "elegant-icon_stop_alt"),
		array("elegant-icon_menu-square_alt" => "elegant-icon_menu-square_alt"),
		array("elegant-icon_menu-circle_alt" => "elegant-icon_menu-circle_alt"),
		array("elegant-icon_document" => "elegant-icon_document"),
		array("elegant-icon_documents" => "elegant-icon_documents"),
		array("elegant-icon_pencil_alt" => "elegant-icon_pencil_alt"),
		array("elegant-icon_folder" => "elegant-icon_folder"),
		array("elegant-icon_folder-open" => "elegant-icon_folder-open"),
		array("elegant-icon_folder-add" => "elegant-icon_folder-add"),
		array("elegant-icon_folder_upload" => "elegant-icon_folder_upload"),
		array("elegant-icon_folder_download" => "elegant-icon_folder_download"),
		array("elegant-icon_info" => "elegant-icon_info"),
		array("elegant-icon_error-circle" => "elegant-icon_error-circle"),
		array("elegant-icon_error-oct" => "elegant-icon_error-oct"),
		array("elegant-icon_error-triangle" => "elegant-icon_error-triangle"),
		array("elegant-icon_question_alt" => "elegant-icon_question_alt"),
		array("elegant-icon_comment" => "elegant-icon_comment"),
		array("elegant-icon_chat" => "elegant-icon_chat"),
		array("elegant-icon_vol-mute" => "elegant-icon_vol-mute"),
		array("elegant-icon_volume-low" => "elegant-icon_volume-low"),
		array("elegant-icon_volume-high" => "elegant-icon_volume-high"),
		array("elegant-icon_quotations_alt" => "elegant-icon_quotations_alt"),
		array("elegant-icon_clock" => "elegant-icon_clock"),
		array("elegant-icon_lock" => "elegant-icon_lock"),
		array("elegant-icon_lock-open" => "elegant-icon_lock-open"),
		array("elegant-icon_key" => "elegant-icon_key"),
		array("elegant-icon_cloud" => "elegant-icon_cloud"),
		array("elegant-icon_cloud-upload" => "elegant-icon_cloud-upload"),
		array("elegant-icon_cloud-download" => "elegant-icon_cloud-download"),
		array("elegant-icon_lightbulb" => "elegant-icon_lightbulb"),
		array("elegant-icon_gift" => "elegant-icon_gift"),
		array("elegant-icon_house" => "elegant-icon_house"),
		array("elegant-icon_camera" => "elegant-icon_camera"),
		array("elegant-icon_mail" => "elegant-icon_mail"),
		array("elegant-icon_cone" => "elegant-icon_cone"),
		array("elegant-icon_ribbon" => "elegant-icon_ribbon"),
		array("elegant-icon_bag" => "elegant-icon_bag"),
		array("elegant-icon_cart" => "elegant-icon_cart"),
		array("elegant-icon_tag" => "elegant-icon_tag"),
		array("elegant-icon_tags" => "elegant-icon_tags"),
		array("elegant-icon_trash" => "elegant-icon_trash"),
		array("elegant-icon_cursor" => "elegant-icon_cursor"),
		array("elegant-icon_mic" => "elegant-icon_mic"),
		array("elegant-icon_compass" => "elegant-icon_compass"),
		array("elegant-icon_pin" => "elegant-icon_pin"),
		array("elegant-icon_pushpin" => "elegant-icon_pushpin"),
		array("elegant-icon_map" => "elegant-icon_map"),
		array("elegant-icon_drawer" => "elegant-icon_drawer"),
		array("elegant-icon_toolbox" => "elegant-icon_toolbox"),
		array("elegant-icon_book" => "elegant-icon_book"),
		array("elegant-icon_contacts" => "elegant-icon_contacts"),
		array("elegant-icon_archive" => "elegant-icon_archive"),
		array("elegant-icon_heart" => "elegant-icon_heart"),
		array("elegant-icon_profile" => "elegant-icon_profile"),
		array("elegant-icon_group" => "elegant-icon_group"),
		array("elegant-icon_grid-2x2" => "elegant-icon_grid-2x2"),
		array("elegant-icon_grid-3x3" => "elegant-icon_grid-3x3"),
		array("elegant-icon_music" => "elegant-icon_music"),
		array("elegant-icon_pause_alt" => "elegant-icon_pause_alt"),
		array("elegant-icon_phone" => "elegant-icon_phone"),
		array("elegant-icon_upload" => "elegant-icon_upload"),
		array("elegant-icon_download" => "elegant-icon_download"),
		array("elegant-social_facebook" => "elegant-social_facebook"),
		array("elegant-social_twitter" => "elegant-social_twitter"),
		array("elegant-social_pinterest" => "elegant-social_pinterest"),
		array("elegant-social_googleplus" => "elegant-social_googleplus"),
		array("elegant-social_tumblr" => "elegant-social_tumblr"),
		array("elegant-social_tumbleupon" => "elegant-social_tumbleupon"),
		array("elegant-social_wordpress" => "elegant-social_wordpress"),
		array("elegant-social_instagram" => "elegant-social_instagram"),
		array("elegant-social_dribbble" => "elegant-social_dribbble"),
		array("elegant-social_vimeo" => "elegant-social_vimeo"),
		array("elegant-social_linkedin" => "elegant-social_linkedin"),
		array("elegant-social_rss" => "elegant-social_rss"),
		array("elegant-social_deviantart" => "elegant-social_deviantart"),
		array("elegant-social_share" => "elegant-social_share"),
		array("elegant-social_myspace" => "elegant-social_myspace"),
		array("elegant-social_skype" => "elegant-social_skype"),
		array("elegant-social_youtube" => "elegant-social_youtube"),
		array("elegant-social_picassa" => "elegant-social_picassa"),
		array("elegant-social_googledrive" => "elegant-social_googledrive"),
		array("elegant-social_flickr" => "elegant-social_flickr"),
		array("elegant-social_blogger" => "elegant-social_blogger"),
		array("elegant-social_spotify" => "elegant-social_spotify"),
		array("elegant-social_delicious" => "elegant-social_delicious"),
		array("elegant-social_facebook_circle" => "elegant-social_facebook_circle"),
		array("elegant-social_twitter_circle" => "elegant-social_twitter_circle"),
		array("elegant-social_pinterest_circle" => "elegant-social_pinterest_circle"),
		array("elegant-social_googleplus_circle" => "elegant-social_googleplus_circle"),
		array("elegant-social_tumblr_circle" => "elegant-social_tumblr_circle"),
		array("elegant-social_stumbleupon_circle" => "elegant-social_stumbleupon_circle"),
		array("elegant-social_wordpress_circle" => "elegant-social_wordpress_circle"),
		array("elegant-social_instagram_circle" => "elegant-social_instagram_circle"),
		array("elegant-social_dribbble_circle" => "elegant-social_dribbble_circle"),
		array("elegant-social_vimeo_circle" => "elegant-social_vimeo_circle"),
		array("elegant-social_linkedin_circle" => "elegant-social_linkedin_circle"),
		array("elegant-social_rss_circle" => "elegant-social_rss_circle"),
		array("elegant-social_deviantart_circle" => "elegant-social_deviantart_circle"),
		array("elegant-social_share_circle" => "elegant-social_share_circle"),
		array("elegant-social_myspace_circle" => "elegant-social_myspace_circle"),
		array("elegant-social_skype_circle" => "elegant-social_skype_circle"),
		array("elegant-social_youtube_circle" => "elegant-social_youtube_circle"),
		array("elegant-social_picassa_circle" => "elegant-social_picassa_circle"),
		array("elegant-social_googledrive_alt2" => "elegant-social_googledrive_alt2"),
		array("elegant-social_flickr_circle" => "elegant-social_flickr_circle"),
		array("elegant-social_blogger_circle" => "elegant-social_blogger_circle"),
		array("elegant-social_spotify_circle" => "elegant-social_spotify_circle"),
		array("elegant-social_delicious_circle" => "elegant-social_delicious_circle"),
		array("elegant-social_facebook_square" => "elegant-social_facebook_square"),
		array("elegant-social_twitter_square" => "elegant-social_twitter_square"),
		array("elegant-social_pinterest_square" => "elegant-social_pinterest_square"),
		array("elegant-social_googleplus_square" => "elegant-social_googleplus_square"),
		array("elegant-social_tumblr_square" => "elegant-social_tumblr_square"),
		array("elegant-social_stumbleupon_square" => "elegant-social_stumbleupon_square"),
		array("elegant-social_wordpress_square" => "elegant-social_wordpress_square"),
		array("elegant-social_instagram_square" => "elegant-social_instagram_square"),
		array("elegant-social_dribbble_square" => "elegant-social_dribbble_square"),
		array("elegant-social_vimeo_square" => "elegant-social_vimeo_square"),
		array("elegant-social_linkedin_square" => "elegant-social_linkedin_square"),
		array("elegant-social_rss_square" => "elegant-social_rss_square"),
		array("elegant-social_deviantart_square" => "elegant-social_deviantart_square"),
		array("elegant-social_share_square" => "elegant-social_share_square"),
		array("elegant-social_myspace_square" => "elegant-social_myspace_square"),
		array("elegant-social_skype_square" => "elegant-social_skype_square"),
		array("elegant-social_youtube_square" => "elegant-social_youtube_square"),
		array("elegant-social_picassa_square" => "elegant-social_picassa_square"),
		array("elegant-social_googledrive_square" => "elegant-social_googledrive_square"),
		array("elegant-social_flickr_square" => "elegant-social_flickr_square"),
		array("elegant-social_blogger_square" => "elegant-social_blogger_square"),
		array("elegant-social_spotify_square" => "elegant-social_spotify_square"),
		array("elegant-social_delicious_square" => "elegant-social_delicious_square"),
		array("elegant-icon_printer" => "elegant-icon_printer"),
		array("elegant-icon_calulator" => "elegant-icon_calulator"),
		array("elegant-icon_building" => "elegant-icon_building"),
		array("elegant-icon_floppy" => "elegant-icon_floppy"),
		array("elegant-icon_drive" => "elegant-icon_drive"),
		array("elegant-icon_search-2" => "elegant-icon_search-2"),
		array("elegant-icon_id" => "elegant-icon_id"),
		array("elegant-icon_id-2" => "elegant-icon_id-2"),
		array("elegant-icon_puzzle" => "elegant-icon_puzzle"),
		array("elegant-icon_like" => "elegant-icon_like"),
		array("elegant-icon_dislike" => "elegant-icon_dislike"),
		array("elegant-icon_mug" => "elegant-icon_mug"),
		array("elegant-icon_currency" => "elegant-icon_currency"),
		array("elegant-icon_wallet" => "elegant-icon_wallet"),
		array("elegant-icon_pens" => "elegant-icon_pens"),
		array("elegant-icon_easel" => "elegant-icon_easel"),
		array("elegant-icon_flowchart" => "elegant-icon_flowchart"),
		array("elegant-icon_datareport" => "elegant-icon_datareport"),
		array("elegant-icon_briefcase" => "elegant-icon_briefcase"),
		array("elegant-icon_shield" => "elegant-icon_shield"),
		array("elegant-icon_percent" => "elegant-icon_percent"),
		array("elegant-icon_globe" => "elegant-icon_globe"),
		array("elegant-icon_globe-2" => "elegant-icon_globe-2"),
		array("elegant-icon_target" => "elegant-icon_target"),
		array("elegant-icon_hourglass" => "elegant-icon_hourglass"),
		array("elegant-icon_balance" => "elegant-icon_balance"),
		array("elegant-icon_rook" => "elegant-icon_rook"),
		array("elegant-icon_printer-alt" => "elegant-icon_printer-alt"),
		array("elegant-icon_calculator_alt" => "elegant-icon_calculator_alt"),
		array("elegant-icon_building_alt" => "elegant-icon_building_alt"),
		array("elegant-icon_floppy_alt" => "elegant-icon_floppy_alt"),
		array("elegant-icon_drive_alt" => "elegant-icon_drive_alt"),
		array("elegant-icon_search_alt" => "elegant-icon_search_alt"),
		array("elegant-icon_id_alt" => "elegant-icon_id_alt"),
		array("elegant-icon_id-2_alt" => "elegant-icon_id-2_alt"),
		array("elegant-icon_puzzle_alt" => "elegant-icon_puzzle_alt"),
		array("elegant-icon_like_alt" => "elegant-icon_like_alt"),
		array("elegant-icon_dislike_alt" => "elegant-icon_dislike_alt"),
		array("elegant-icon_mug_alt" => "elegant-icon_mug_alt"),
		array("elegant-icon_currency_alt" => "elegant-icon_currency_alt"),
		array("elegant-icon_wallet_alt" => "elegant-icon_wallet_alt"),
		array("elegant-icon_pens_alt" => "elegant-icon_pens_alt"),
		array("elegant-icon_easel_alt" => "elegant-icon_easel_alt"),
		array("elegant-icon_flowchart_alt" => "elegant-icon_flowchart_alt"),
		array("elegant-icon_datareport_alt" => "elegant-icon_datareport_alt"),
		array("elegant-icon_briefcase_alt" => "elegant-icon_briefcase_alt"),
		array("elegant-icon_shield_alt" => "elegant-icon_shield_alt"),
		array("elegant-icon_percent_alt" => "elegant-icon_percent_alt"),
		array("elegant-icon_globe_alt" => "elegant-icon_globe_alt"),
		array("elegant-icon_clipboard" => "elegant-icon_clipboard")
    );
}
add_filter( 'vc_iconpicker-type-extraicon2', 'vc_iconpicker_type_extraicon2' );
function vc_iconpicker_type_extraicon2() {
    return array(
		array("pe-7s-album" => "pe-7s-album"),
		array("pe-7s-arc" => "pe-7s-arc"),
		array("pe-7s-back-2" => "pe-7s-back-2"),
		array("pe-7s-bandaid" => "pe-7s-bandaid"),
		array("pe-7s-car" => "pe-7s-car"),
		array("pe-7s-diamond" => "pe-7s-diamond"),
		array("pe-7s-door-lock" => "pe-7s-door-lock"),
		array("pe-7s-eyedropper" => "pe-7s-eyedropper"),
		array("pe-7s-female" => "pe-7s-female"),
		array("pe-7s-gym" => "pe-7s-gym"),
		array("pe-7s-hammer" => "pe-7s-hammer"),
		array("pe-7s-headphones" => "pe-7s-headphones"),
		array("pe-7s-helm" => "pe-7s-helm"),
		array("pe-7s-hourglass" => "pe-7s-hourglass"),
		array("pe-7s-leaf" => "pe-7s-leaf"),
		array("pe-7s-magic-wand" => "pe-7s-magic-wand"),
		array("pe-7s-male" => "pe-7s-male"),
		array("pe-7s-map-2" => "pe-7s-map-2"),
		array("pe-7s-next-2" => "pe-7s-next-2"),
		array("pe-7s-paint-bucket" => "pe-7s-paint-bucket"),
		array("pe-7s-pendrive" => "pe-7s-pendrive"),
		array("pe-7s-photo" => "pe-7s-photo"),
		array("pe-7s-piggy" => "pe-7s-piggy"),
		array("pe-7s-plugin" => "pe-7s-plugin"),
		array("pe-7s-refresh-2" => "pe-7s-refresh-2"),
		array("pe-7s-rocket" => "pe-7s-rocket"),
		array("pe-7s-settings" => "pe-7s-settings"),
		array("pe-7s-shield" => "pe-7s-shield"),
		array("pe-7s-smile" => "pe-7s-smile"),
		array("pe-7s-usb" => "pe-7s-usb"),
		array("pe-7s-vector" => "pe-7s-vector"),
		array("pe-7s-wine" => "pe-7s-wine"),
		array("pe-7s-cloud-upload" => "pe-7s-cloud-upload"),
		array("pe-7s-cash" => "pe-7s-cash"),
		array("pe-7s-close" => "pe-7s-close"),
		array("pe-7s-bluetooth" => "pe-7s-bluetooth"),
		array("pe-7s-cloud-download" => "pe-7s-cloud-download"),
		array("pe-7s-way" => "pe-7s-way"),
		array("pe-7s-close-circle" => "pe-7s-close-circle"),
		array("pe-7s-id" => "pe-7s-id"),
		array("pe-7s-angle-up" => "pe-7s-angle-up"),
		array("pe-7s-wristwatch" => "pe-7s-wristwatch"),
		array("pe-7s-angle-up-circle" => "pe-7s-angle-up-circle"),
		array("pe-7s-world" => "pe-7s-world"),
		array("pe-7s-angle-right" => "pe-7s-angle-right"),
		array("pe-7s-volume" => "pe-7s-volume"),
		array("pe-7s-angle-right-circle" => "pe-7s-angle-right-circle"),
		array("pe-7s-users" => "pe-7s-users"),
		array("pe-7s-angle-left" => "pe-7s-angle-left"),
		array("pe-7s-user-female" => "pe-7s-user-female"),
		array("pe-7s-angle-left-circle" => "pe-7s-angle-left-circle"),
		array("pe-7s-up-arrow" => "pe-7s-up-arrow"),
		array("pe-7s-angle-down" => "pe-7s-angle-down"),
		array("pe-7s-switch" => "pe-7s-switch"),
		array("pe-7s-angle-down-circle" => "pe-7s-angle-down-circle"),
		array("pe-7s-scissors" => "pe-7s-scissors"),
		array("pe-7s-wallet" => "pe-7s-wallet"),
		array("pe-7s-safe" => "pe-7s-safe"),
		array("pe-7s-volume2" => "pe-7s-volume2"),
		array("pe-7s-volume1" => "pe-7s-volume1"),
		array("pe-7s-voicemail" => "pe-7s-voicemail"),
		array("pe-7s-video" => "pe-7s-video"),
		array("pe-7s-user" => "pe-7s-user"),
		array("pe-7s-upload" => "pe-7s-upload"),
		array("pe-7s-unlock" => "pe-7s-unlock"),
		array("pe-7s-umbrella" => "pe-7s-umbrella"),
		array("pe-7s-trash" => "pe-7s-trash"),
		array("pe-7s-tools" => "pe-7s-tools"),
		array("pe-7s-timer" => "pe-7s-timer"),
		array("pe-7s-ticket" => "pe-7s-ticket"),
		array("pe-7s-target" => "pe-7s-target"),
		array("pe-7s-sun" => "pe-7s-sun"),
		array("pe-7s-study" => "pe-7s-study"),
		array("pe-7s-stopwatch" => "pe-7s-stopwatch"),
		array("pe-7s-star" => "pe-7s-star"),
		array("pe-7s-speaker" => "pe-7s-speaker"),
		array("pe-7s-signal" => "pe-7s-signal"),
		array("pe-7s-shuffle" => "pe-7s-shuffle"),
		array("pe-7s-shopbag" => "pe-7s-shopbag"),
		array("pe-7s-share" => "pe-7s-share"),
		array("pe-7s-server" => "pe-7s-server"),
		array("pe-7s-search" => "pe-7s-search"),
		array("pe-7s-film" => "pe-7s-film"),
		array("pe-7s-science" => "pe-7s-science"),
		array("pe-7s-disk" => "pe-7s-disk"),
		array("pe-7s-ribbon" => "pe-7s-ribbon"),
		array("pe-7s-repeat" => "pe-7s-repeat"),
		array("pe-7s-refresh" => "pe-7s-refresh"),
		array("pe-7s-add-user" => "pe-7s-add-user"),
		array("pe-7s-refresh-cloud" => "pe-7s-refresh-cloud"),
		array("pe-7s-paperclip" => "pe-7s-paperclip"),
		array("pe-7s-radio" => "pe-7s-radio"),
		array("pe-7s-note2" => "pe-7s-note2"),
		array("pe-7s-print" => "pe-7s-print"),
		array("pe-7s-network" => "pe-7s-network"),
		array("pe-7s-prev" => "pe-7s-prev"),
		array("pe-7s-mute" => "pe-7s-mute"),
		array("pe-7s-power" => "pe-7s-power"),
		array("pe-7s-medal" => "pe-7s-medal"),
		array("pe-7s-portfolio" => "pe-7s-portfolio"),
		array("pe-7s-like2" => "pe-7s-like2"),
		array("pe-7s-plus" => "pe-7s-plus"),
		array("pe-7s-left-arrow" => "pe-7s-left-arrow"),
		array("pe-7s-play" => "pe-7s-play"),
		array("pe-7s-key" => "pe-7s-key"),
		array("pe-7s-plane" => "pe-7s-plane"),
		array("pe-7s-joy" => "pe-7s-joy"),
		array("pe-7s-photo-gallery" => "pe-7s-photo-gallery"),
		array("pe-7s-pin" => "pe-7s-pin"),
		array("pe-7s-phone" => "pe-7s-phone"),
		array("pe-7s-plug" => "pe-7s-plug"),
		array("pe-7s-pen" => "pe-7s-pen"),
		array("pe-7s-right-arrow" => "pe-7s-right-arrow"),
		array("pe-7s-paper-plane" => "pe-7s-paper-plane"),
		array("pe-7s-delete-user" => "pe-7s-delete-user"),
		array("pe-7s-paint" => "pe-7s-paint"),
		array("pe-7s-bottom-arrow" => "pe-7s-bottom-arrow"),
		array("pe-7s-notebook" => "pe-7s-notebook"),
		array("pe-7s-note" => "pe-7s-note"),
		array("pe-7s-next" => "pe-7s-next"),
		array("pe-7s-news-paper" => "pe-7s-news-paper"),
		array("pe-7s-musiclist" => "pe-7s-musiclist"),
		array("pe-7s-music" => "pe-7s-music"),
		array("pe-7s-mouse" => "pe-7s-mouse"),
		array("pe-7s-more" => "pe-7s-more"),
		array("pe-7s-moon" => "pe-7s-moon"),
		array("pe-7s-monitor" => "pe-7s-monitor"),
		array("pe-7s-micro" => "pe-7s-micro"),
		array("pe-7s-menu" => "pe-7s-menu"),
		array("pe-7s-map" => "pe-7s-map"),
		array("pe-7s-map-marker" => "pe-7s-map-marker"),
		array("pe-7s-mail" => "pe-7s-mail"),
		array("pe-7s-mail-open" => "pe-7s-mail-open"),
		array("pe-7s-mail-open-file" => "pe-7s-mail-open-file"),
		array("pe-7s-magnet" => "pe-7s-magnet"),
		array("pe-7s-loop" => "pe-7s-loop"),
		array("pe-7s-look" => "pe-7s-look"),
		array("pe-7s-lock" => "pe-7s-lock"),
		array("pe-7s-lintern" => "pe-7s-lintern"),
		array("pe-7s-link" => "pe-7s-link"),
		array("pe-7s-like" => "pe-7s-like"),
		array("pe-7s-light" => "pe-7s-light"),
		array("pe-7s-less" => "pe-7s-less"),
		array("pe-7s-keypad" => "pe-7s-keypad"),
		array("pe-7s-junk" => "pe-7s-junk"),
		array("pe-7s-info" => "pe-7s-info"),
		array("pe-7s-home" => "pe-7s-home"),
		array("pe-7s-help2" => "pe-7s-help2"),
		array("pe-7s-help1" => "pe-7s-help1"),
		array("pe-7s-graph3" => "pe-7s-graph3"),
		array("pe-7s-graph2" => "pe-7s-graph2"),
		array("pe-7s-graph1" => "pe-7s-graph1"),
		array("pe-7s-graph" => "pe-7s-graph"),
		array("pe-7s-global" => "pe-7s-global"),
		array("pe-7s-gleam" => "pe-7s-gleam"),
		array("pe-7s-glasses" => "pe-7s-glasses"),
		array("pe-7s-gift" => "pe-7s-gift"),
		array("pe-7s-folder" => "pe-7s-folder"),
		array("pe-7s-flag" => "pe-7s-flag"),
		array("pe-7s-filter" => "pe-7s-filter"),
		array("pe-7s-file" => "pe-7s-file"),
		array("pe-7s-expand1" => "pe-7s-expand1"),
		array("pe-7s-exapnd2" => "pe-7s-exapnd2"),
		array("pe-7s-edit" => "pe-7s-edit"),
		array("pe-7s-drop" => "pe-7s-drop"),
		array("pe-7s-drawer" => "pe-7s-drawer"),
		array("pe-7s-download" => "pe-7s-download"),
		array("pe-7s-display2" => "pe-7s-display2"),
		array("pe-7s-display1" => "pe-7s-display1"),
		array("pe-7s-diskette" => "pe-7s-diskette"),
		array("pe-7s-date" => "pe-7s-date"),
		array("pe-7s-cup" => "pe-7s-cup"),
		array("pe-7s-culture" => "pe-7s-culture"),
		array("pe-7s-crop" => "pe-7s-crop"),
		array("pe-7s-credit" => "pe-7s-credit"),
		array("pe-7s-copy-file" => "pe-7s-copy-file"),
		array("pe-7s-config" => "pe-7s-config"),
		array("pe-7s-compass" => "pe-7s-compass"),
		array("pe-7s-comment" => "pe-7s-comment"),
		array("pe-7s-coffee" => "pe-7s-coffee"),
		array("pe-7s-cloud" => "pe-7s-cloud"),
		array("pe-7s-clock" => "pe-7s-clock"),
		array("pe-7s-check" => "pe-7s-check"),
		array("pe-7s-chat" => "pe-7s-chat"),
		array("pe-7s-cart" => "pe-7s-cart"),
		array("pe-7s-camera" => "pe-7s-camera"),
		array("pe-7s-call" => "pe-7s-call"),
		array("pe-7s-calculator" => "pe-7s-calculator"),
		array("pe-7s-browser" => "pe-7s-browser"),
		array("pe-7s-box2" => "pe-7s-box2"),
		array("pe-7s-box1" => "pe-7s-box1"),
		array("pe-7s-bookmarks" => "pe-7s-bookmarks"),
		array("pe-7s-bicycle" => "pe-7s-bicycle"),
		array("pe-7s-bell" => "pe-7s-bell"),
		array("pe-7s-battery" => "pe-7s-battery"),
		array("pe-7s-ball" => "pe-7s-ball"),
		array("pe-7s-back" => "pe-7s-back"),
		array("pe-7s-attention" => "pe-7s-attention"),
		array("pe-7s-anchor" => "pe-7s-anchor"),
		array("pe-7s-albums" => "pe-7s-albums"),
		array("pe-7s-alarm" => "pe-7s-alarm"),
		array("pe-7s-airplay" => "pe-7s-airplay")
    );
}

// Return simple fonts array
if ( ! function_exists('startflow_plugin_google_font') ) {
	function startflow_plugin_google_font() {
		if ( function_exists('startflow_google_fonts_array') ) {
			$default = array( 0 => 'Default' );
			return array_merge( $default, startflow_google_fonts_array() );
		} else {
			return array(
				'Default', 'Arial, Helvetica, sans-serif', 'Arial Black, Gadget, sans-serif',
				'Bookman Old Style, serif', 'Comic Sans MS, cursive', 'Courier, monospace',
				'Georgia, serif', 'Garamond, serif', 'Impact, Charcoal, sans-serif', 'Lucida Console, Monaco, monospace',
				'Lucida Sans Unicode, Lucida Grande, sans-serif', 'MS Sans Serif, Geneva, sans-serif', 'MS Serif, New York, sans-serif',
				'Palatino Linotype, Book Antiqua, Palatino, serif', 'Tahoma, Geneva, sans-serif', 'Times New Roman, Times, serif',
				'Trebuchet MS, Helvetica, sans-serif', 'Verdana, Geneva, sans-serif', 'Paratina Linotype', 'Trebuchet MS',
			);
		}
	}
}

// Get icon font base on font icon type
if ( ! function_exists('startflow_get_icon_class') ) {
	function startflow_get_icon_class( $atts, $icon_location ) {
		// Define vars
		$icon = '';
		$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : 'fontawesome';

		// Generate fontawesome icon class
		if ( 'fontawesome' == $icon_type && ! empty( $atts[$icon_location] ) ) {
			$icon = $atts[$icon_location];
			$icon = str_replace( 'fa-', '', $icon );
			$icon = str_replace( 'fa ', '', $icon );
			$icon = 'fa fa-'. $icon;
		} elseif ( ! empty( $atts[ $icon_location .'_'. $icon_type ] ) ) {
			$icon = $atts[ $icon_location .'_'. $icon_type ];
		}

		// Sanitize
		$icon = in_array( $icon, array( 'icon', 'none' ) ) ? '' : $icon;

		// Return icon class
		return $icon;
	}
}

// Spacing
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Spacing', 'startflow'),
        'description' => esc_html__('Empty space with custom height.', 'startflow'),
        'base' => 'spacing',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Desktop: Height', 'startflow'),
				'param_name' => 'desktop_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Mobile: Height', 'startflow'),
				'param_name' => 'mobile_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Small Mobile: Height', 'startflow'),
				'param_name' => 'smobile_height',
				'value' => '',
	        ),
        )
    ) );
} );

// Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_carouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Carousel Box', 'startflow'),
		'description' => esc_html__('Scrolling anything.', 'startflow'),
		'base' => 'carouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'contentbox, imagebox, iconbox, videoicon, simpleimage, headings, fancytext, singleheading, pricetable, counter'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'startflow' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'startflow'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'startflow'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'startflow' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'startflow' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Center Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_centercarouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Center Carousel Box', 'startflow'),
		'description' => esc_html__('Scrolling anything.', 'startflow'),
		'base' => 'centercarouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'contentbox, imagebox, iconbox, simpleimage, pricetable'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'true',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Spacing Between', 'startflow' ),
				'param_name' => 'gap',
				'value'      => array(
					'0px' => '0',
					'10px' => '10',
					'20px' => '20',
					'30px' => '30',
					'40px' => '40',
					'50px' => '50',
					'60px' => '60',
				),
				'std'		=> '30',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Slide Show', 'startflow' ),
				'param_name' => 'slide',
				'value'      => array(
					'1' => '1',
					'3' => '3',
				),
				'std'		=> '3',
			),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Padding Content', 'startflow'),
				'param_name' => 'padding',
				'value' => 15,
				'suffix' => '%',
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'40px' => '40',
					'30px' => '30',
					'20px' => '20',
					'10px' => '10',
					'0px' => '0',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
        )
    ) );
} );

// Portfolio Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Portfolio Carousel', 'startflow'),
        'description' => esc_html__('Displaying project posts in carousel.', 'startflow'),
        'base' => 'portfolio',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Margin', 'startflow'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'startflow'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Default' => 'default',
					'Full' => 'full',
					'770 x 770' => 'square',
					'770 x 385' => 'rectangle',
					'770 x 850' => 'rectangle1',
					'770 x 700' => 'rectangle2',
					'640 x 480' => 'rectangle3',
					'640 x 400' => 'rectangle4',
					'600 x 400' => 'rectangle5',
					'370 x 630' => 'rectangle6',
					'370 x 500' => 'rectangle10',
					'370 x 370' => 'rectangle7',
					'385 x 385' => 'rectangle8',
					'370 x 300' => 'rectangle9',
				),
				'std'		=> 'rectangle3',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gap',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'startflow'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Rounded Image?', 'startflow' ),
				'param_name' => 'rounded',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'startflow'),
				'param_name' => 'items',
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'startflow'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'startflow'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'startflow'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'startflow' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'startflow' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Portfolio Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Portfolio Grid', 'startflow'),
        'description' => esc_html__('Displaying project posts in grid with filter bar.', 'startflow'),
        'base' => 'portfoliogrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text on Hover', 'startflow'),
				'param_name' => 'hover_text',
				'value' => 'View Case Study',
				'dependency' => array( 'element' => 'style', 'value' => 'style-2' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Margin', 'startflow'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'startflow'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'startflow' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Masonry' => 'masonry',
					'Mosaic' => 'mosaic',
				),
				'std'		=> 'masonry',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Default' => 'default',
					'Full' => 'full',
					'770 x 770' => 'square',
					'770 x 385' => 'rectangle',
					'770 x 850' => 'rectangle1',
					'770 x 700' => 'rectangle2',
					'640 x 480' => 'rectangle3',
					'640 x 400' => 'rectangle4',
					'600 x 400' => 'rectangle5',
					'370 x 630' => 'rectangle6',
					'370 x 500' => 'rectangle10',
					'370 x 370' => 'rectangle7',
					'385 x 385' => 'rectangle8',
					'370 x 300' => 'rectangle9',
				),
				'std'		=> 'rectangle3',
				'description'	=> esc_html__('Choose <Default> to use Image-Cropping from metabox.', 'startflow'),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gapv',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'startflow'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'startflow'),
				'param_name' => 'gaph',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'startflow'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Rounded Image?', 'startflow' ),
				'param_name' => 'rounded',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
            // Query
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'startflow'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'startflow' ),
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'startflow'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'startflow'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'startflow'),
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Pagination?', 'startflow' ),
				'param_name' => 'pagination',
				'group' => esc_html__( 'Query', 'startflow' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
			// Filter
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Filter Bar?', 'startflow' ),
				'param_name' => 'show_filter',
				'group' => esc_html__( 'Filter', 'startflow' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: All', 'startflow'),
				'param_name' => 'filter_button_all',
				'value' => 'All',
				'group' => esc_html__( 'Filter', 'startflow' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'startflow'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'startflow'),
				'param_name' => 'bottom_filter',
				'value' => '',
				'description'	=> esc_html__('Ex: 45px.', 'startflow'),
				'group' => esc_html__( 'Filter', 'startflow' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter Alignment', 'startflow' ),
				'param_name' => 'filter_align',
				'value'      => array(
					'Left' => 'style-1',
					'Center' => 'style-2',
					'Right' => 'style-3',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Filter', 'startflow' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Counter?', 'startflow' ),
				'param_name' => 'show_counter',
				'group' => esc_html__( 'Filter', 'startflow' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Filter posts by default?', 'startflow' ),
				'param_name' => 'filter_by_default',
				'group' => esc_html__( 'Filter', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'startflow'),
				'param_name' => 'filter_cat_slug',
				'value' => '',
				'group' => esc_html__( 'Filter', 'startflow' ),
				'dependency' => array( 'element' => 'filter_by_default', 'value' => 'yes' ),
				'description'	=> esc_html__('Filter posts from this category by default. Using category-slug.', 'startflow'),
	        ),
            // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Family', 'startflow' ),
				'param_name' => 'filter_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Weight', 'startflow' ),
				'param_name' => 'filter_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Font Size', 'startflow'),
				'param_name' => 'filter_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Line-Height', 'startflow'),
				'param_name' => 'filter_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Letter Spacing', 'startflow'),
				'param_name' => 'filter_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Text Transform', 'startflow' ),
				'param_name' => 'filter_text_tranform',
				'value'      => array(
					'Capitalize' => 'capitalize',
					'Uppercase' => 'uppercase',
				),
				'std'		=> 'capitalize',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'startflow' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Testimonials Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials Box' , 'startflow'),
	    'description' => esc_html__('Displaying testimonials box.', 'startflow'),
	    'base' => 'testimonialsbox',
		'weight'	=>	180,
		'show_settings_on_create' => true,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Query Posts', 'startflow'),
				'param_name' => 'items',
				'value' => '3',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Borders?', 'startflow' ),
				'param_name' => 'borders',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
		)
	) );
} );

// Testimonials Post
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials Post' , 'startflow'),
	    'description' => esc_html__('Displaying testimonials posts.', 'startflow'),
	    'base' => 'testimonialspost',
		'weight'	=>	180,
		'show_settings_on_create' => true,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Query Posts', 'startflow'),
				'param_name' => 'items',
				'value' => '5',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Stars?', 'startflow' ),
				'param_name' => 'stars',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Borders?', 'startflow' ),
				'param_name' => 'borders',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			// Carousel Option
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Center Mode?', 'startflow' ),
				'param_name' => 'center_mode',
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
				'group' => esc_html__( 'Carousel Option', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Slide Show', 'startflow' ),
				'param_name' => 'slide1',
				'value'      => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
				),
				'std'		=> '3',
				'group' => esc_html__( 'Carousel Option', 'startflow' ),
				'dependency' => array( 'element' => 'center_mode', 'value' => 'false' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Slide Show', 'startflow' ),
				'param_name' => 'slide2',
				'value'      => array(
					'1' => '1',
					'3' => '3',
				),
				'std'		=> '1',
				'group' => esc_html__( 'Carousel Option', 'startflow' ),
				'dependency' => array( 'element' => 'center_mode', 'value' => 'true' ),
			),
	        array(
				'type' => 'number',
				'heading' => esc_html__('Padding Content', 'startflow'),
				'param_name' => 'padding_content',
				'value' => 35,
				'suffix' => '%',
				'group' => esc_html__( 'Carousel Option', 'startflow' ),
				'dependency' => array( 'element' => 'center_mode', 'value' => 'true' ),
	        ),
		)
	) );
} );

// News Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('News Carousel', 'startflow'),
	    'description' => esc_html__('Displaying blog posts in carousel.', 'startflow'),
	    'base' => 'news',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Thumbnail Image', 'startflow' ),
				'param_name' => 'thumb',
				'value'      => array(
					'Featured Image' => 'featured-image',
					'Element Thumbnail' => 'element-thumbnail',
				),
				'std'		=> 'featured-image',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Thumbnail Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'770 x 420' => 'standard',
					'570 x 370' => 'element',
				),
				'std'		=> 'element',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding.', 'startflow'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 17px 30px 17px', 'startflow'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background', 'startflow'),
				'param_name' => 'content_background',
				'value' => '#ffffff',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide Date?', 'startflow' ),
				'param_name' => 'hide_date',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'startflow'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'startflow'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'startflow'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'startflow'),
	        ),
			// Link
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Text', 'startflow'),
				'param_name' => 'link_text',
				'value' => 'Read more',
				'group' => esc_html__( 'Link', 'startflow' ),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'startflow' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Center' => 'center',
					'Top' => 'top',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'startflow' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'top' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'startflow'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'startflow'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	    )
	) );
} );

// ProgressBar
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Progress Bar', 'startflow'),
        'description' => esc_html__('Displaying progress bars.', 'startflow'),
        'base' => 'progressbar',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'startflow'),
				'param_name' => 'title',
				'value' => esc_html__('Title', 'startflow'),
				'description' => esc_html__('Title of the ProgressBar.', 'startflow')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'startflow'),
				'param_name' => 'title_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Percentage', 'startflow'),
				'param_name' => 'percent',
				'value' => '90',
				'description' => esc_html__('Percentage value of the ProgressBar', 'startflow')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Percentage Color', 'startflow'),
				'param_name' => 'per_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height of Bars', 'startflow'),
				'param_name' => 'height',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Space between Text & Line', 'startflow'),
				'param_name' => 'space_between',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'startflow'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'startflow'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'description'	=> esc_html__('Ex: 20px', 'startflow'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1', 'startflow'),
				'param_name' => 'line_one',
				'value' => '#636363',
				'group' => esc_html__( 'Line Color', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2', 'startflow'),
				'param_name' => 'line_two',
				'value' => '#e5e5e5',
				'group' => esc_html__( 'Line Color', 'startflow' ),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable gradient color?', 'startflow' ),
				'param_name' => 'gradient',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'group' => esc_html__( 'Line Color', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'startflow' ),
				'param_name' => 'font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'startflow' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'startflow'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
        )
    ) );
} );

// Accordions
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_accordions extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Accordions or Toggles', 'startflow' ),
        'description' => esc_html__('Displaying Accordions or Toggles', 'startflow'),
		'base'        => 'accordions',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'accordion' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Type', 'startflow' ),
				'param_name' => 'type',
				'value'      => array(
					'Accordions' => 'accordions',
					'Toggles' => 'toggles',
				),
				'std'		=> 'accordions',
			),
		)
	) );
} );

// Accordion
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Item', 'startflow' ),
    'description' => esc_html__('Item for Accordions or Toggles', 'startflow'),
		'base'        => 'accordion',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'as_child'    => array( 'only' => 'accordions' ),
		'params'      => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Active by default?', 'startflow' ),
				'param_name' => 'open',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'startflow'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Bottom Margin', 'startflow'),
				'param_name' => 'bottom_margin',
				'value' => 10,
				'suffix' => 'px',
				'description'	=> esc_html__('Default: 10px', 'startflow'),
		  	),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Heading', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Padding', 'startflow'),
				'param_name' => 'heading_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 25px 13px 25px', 'startflow'),
				'group' => esc_html__( 'Heading', 'startflow' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'heading_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 25px', 'startflow'),
				'group' => esc_html__( 'Heading', 'startflow' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'startflow'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'startflow'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 0px 30px 0px', 'startflow'),
				'group' => esc_html__( 'Content', 'startflow' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// Tabs
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_dtabs extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Tabs', 'startflow' ),
        'description' => esc_html__('Displaying Tabbed Content.', 'startflow'),
		'base'        => 'dtabs',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'dtab' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Width', 'startflow' ),
				'param_name' => 'title_width',
				'value'      => array(
					'150px' => 'w150',
					'160px' => 'w160',
					'170px' => 'w170',
					'180px' => 'w180',
					'190px' => 'w190',
					'200px' => 'w200',
					'220px' => 'w220',
					'240px' => 'w240',
					'260px' => 'w260',
					'280px' => 'w280',
					'300px' => 'w300',
				),
				'std'		=> 'w190',
				'dependency' => array( 'element' => 'style', 'value' => array('style-3','style-4')),
	        ),
		)
	) );
} );

// Tab
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Tab', 'startflow' ),
    'description' => esc_html__('Displaying Tab.', 'startflow'),
		'base'        => 'dtab',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'as_child'    => array( 'only' => 'dtabs' ),
		'params'      => array(
			// Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'startflow'),
				'param_name' => 'title',
				'value' => 'Tab',
				'group' => esc_html__( 'Title', 'startflow' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'startflow'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'startflow'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 20px 0px 0px 37px;', 'startflow'),
				'group' => esc_html__( 'Content', 'startflow' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Family', 'startflow' ),
				'param_name' => 'title_font_family',
				'value'      => startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Weight', 'startflow' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Size', 'startflow'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Line-Height', 'startflow'),
				'param_name' => 'title_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// Team Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Team Carousel', 'startflow'),
	    'description' => esc_html__('Displaying member posts in carousel.', 'startflow'),
	    'base' => 'team',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'startflow'),
				'param_name' => 'items',
				'value' => '4',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'startflow'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'startflow' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'startflow'),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'startflow' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Center' => 'center',
					'Top' => 'top',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'startflow' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'top' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'startflow'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'startflow' ),
				'param_name' => 'name_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'startflow' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'startflow'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'startflow'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'startflow'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'startflow'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'startflow' ),
				'param_name' => 'position_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'startflow' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'startflow'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'startflow'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'startflow'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'startflow'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Family', 'startflow' ),
				'param_name' => 'text_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Weight', 'startflow' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'startflow'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Font Size', 'startflow'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Line-Height', 'startflow'),
				'param_name' => 'text_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'startflow'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'startflow'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'startflow'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'startflow'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Top Margin', 'startflow'),
				'param_name' => 'text_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Bottom Margin', 'startflow'),
				'param_name' => 'text_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	    )
	) );
} );

// Team Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Team Grid', 'startflow'),
	    'description' => esc_html__('Displaying member posts in grid.', 'startflow'),
	    'base' => 'teamgrid',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'startflow'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'startflow'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gapv',
				'value' => '30',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'startflow'),
				'param_name' => 'gaph',
				'value' => '40',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Column(s)', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'startflow'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'startflow' ),
				'param_name' => 'name_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'startflow' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'startflow'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'startflow'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'startflow'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'startflow'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'startflow' ),
				'param_name' => 'position_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'startflow' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'startflow'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'startflow'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'startflow'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'startflow'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Family', 'startflow' ),
				'param_name' => 'text_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Weight', 'startflow' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'startflow'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Font Size', 'startflow'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Line-Height', 'startflow'),
				'param_name' => 'text_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'startflow'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'startflow'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'startflow'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'startflow'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Top Margin', 'startflow'),
				'param_name' => 'text_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Bottom Margin', 'startflow'),
				'param_name' => 'text_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	    )
	) );
} );

// Action Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Action Box', 'startflow'),
	    'description' => esc_html__('Displaying Action-Box or Promo-Box.', 'startflow'),
	    'base' => 'actionbox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Area: Width', 'startflow'),
				'param_name' => 'content_width',
				'value' => '',
				'description'	=> esc_html__('Default: 70%', 'startflow'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Area: Alignment', 'startflow' ),
				'param_name' => 'content_align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Area: Width', 'startflow'),
				'param_name' => 'button_width',
				'value' => '',
				'description'	=> esc_html__('Default: 20%', 'startflow'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Area: Alignment', 'startflow' ),
				'param_name' => 'button_align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-right',
			),
            // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_content',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'startflow' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading Text', 'startflow'),
				'param_name' => 'heading_text',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'startflow'),
				'param_name' => 'heading_width',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading', 'startflow' ),
				'param_name' => 'subheading_text',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'startflow'),
				'param_name' => 'subheading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'startflow'),
				'param_name' => 'subheading_width',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            // Button
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Button Text (Required)', 'startflow'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'startflow' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button URL (Required):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'startflow' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'Button', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'startflow'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'startflow'),
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'startflow'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'startflow'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'startflow'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'Button', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'startflow' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Button', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'startflow'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'startflow'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'startflow'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'startflow'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
            ),
            // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'startflow'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'startflow' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'startflow' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'startflow'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'startflow'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'startflow'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'startflow' ),
				'param_name' => 'button_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'startflow' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'startflow'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'startflow'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Margin', 'startflow'),
				'param_name' => 'heading_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Margin', 'startflow'),
				'param_name' => 'button_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	    )
	) );
} );

// Image Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Image Box', 'startflow'),
	    'description' => esc_html__('Displaying image box.', 'startflow'),
	    'base' => 'imagebox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'startflow'),
				'param_name' => 'image',
				'value' => '',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Image Icon?', 'startflow' ),
				'param_name' => 'show_icon',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'description'	=> esc_html__('Heading URL Required.', 'startflow'),
				'dependency' => array( 'element' => 'style', 'value' => array( 'style-1', 'style-3' ) ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'startflow'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'startflow'),
				'dependency' => array( 'element' => 'style', 'value' => array( 'style-1', 'style-3' ) ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background', 'startflow'),
				'param_name' => 'content_bg',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => array( 'style-1', 'style-3' ) ),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Number?', 'startflow' ),
				'param_name' => 'show_number',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'dependency' => array( 'element' => 'style', 'value' => 'style-3' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'conceptseven'),
				'param_name' => 'number',
				'value' => '',
				'dependency' => array( 'element' => 'show_number', 'value' => 'yes' ),
            ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'hading_content',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading URL (Optional):', 'startflow'),
				'param_name' => 'heading_url',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'startflow'),
				'param_name' => 'desc_content',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Description', 'startflow'),
				'param_name' 	=> 'description',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'startflow'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array( 'style-1', 'style-3' ) ),
            ),
			// Button or Link
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Link or Button?', 'startflow' ),
				'param_name' => 'show_url',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'group' => esc_html__( 'URL', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'url_style',
				'value'      => array(
					'Link' => 'link',
					'Button' => 'button',
				),
				'std'		=> 'link',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Link Style', 'startflow' ),
				'param_name' => 'link_style',
				'value'      => array(
					'Style 1' => 'link-style-1',
					'Style 2' => 'link-style-2',
				),
				'std'		=> 'link-style-1',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'startflow'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text (Required)', 'startflow'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'startflow' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'startflow'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'startflow'),
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'startflow'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'startflow'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'startflow'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'startflow' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border Color', 'startflow'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'startflow'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'startflow'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'startflow'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'startflow'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'startflow' ),
				'param_name' => 'desc_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'startflow' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'startflow'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'startflow'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'startflow'),
				'param_name' => 'btn_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'startflow' ),
				'param_name' => 'button_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'startflow' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'startflow'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'startflow'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'startflow'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'startflow'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'startflow'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	    )
	) );
} );

// Links
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Links', 'startflow' ),
        'description' => esc_html__('Displaying a link.', 'startflow'),
		'base'        => 'advlinks',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content (Required)', 'startflow' ),
				'param_name' => 'content',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'startflow'),
				'param_name' => 'color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (Required)', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
            ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'startflow' ),
				'param_name' => 'content_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'startflow' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'startflow'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// List
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'List', 'startflow' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'startflow'),
		'base'        => 'advlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'content_background_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'startflow' ),
				'param_name' => 'content_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'startflow'),
				'param_name' => 'content_border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'startflow'),
				'param_name' => 'content_border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'startflow'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 12px 30px 12px 30px', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'startflow'),
				'param_name' => 'content_bottom_margin',
				'value' => '',
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'startflow' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'startflow' ),
				'value' => array(
					esc_html__( '', 'startflow' ) => '',
					esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
					esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
					esc_html__( 'FontAwesome', 'startflow' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
					esc_html__( 'Typicons', 'startflow' ) => 'typicons',
					esc_html__( 'Entypo', 'startflow' ) => 'entypo',
					esc_html__( 'Linecons', 'startflow' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon2',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon2',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon2',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'startflow' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'Simple' => 'simple',
					'Background' => 'background',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background', 'startflow'),
				'param_name' => 'icon_bg',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'startflow'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Width', 'startflow'),
				'param_name' => 'icon_width',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Height', 'startflow'),
				'param_name' => 'icon_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Rounded', 'startflow'),
				'param_name' => 'icon_rounded',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'startflow'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-Height', 'startflow'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'startflow' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Middle' => 'icon-middle',
					'Top' => 'icon-top',
				),
				'std'		=> 'icon-middle',
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Icon Top Margin', 'startflow' ),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			// Content
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content', 'startflow' ),
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'startflow' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'startflow'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Left Padding', 'startflow'),
				'param_name' => 'content_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Content', 'startflow' ),
				'description'	=> esc_html__('Spacing between the icon and the content', 'startflow'),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Family', 'startflow' ),
				'param_name' => 'content_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Weight', 'startflow' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Font Size', 'startflow'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Line-Height', 'startflow'),
				'param_name' => 'content_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// Menu List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Menu List', 'startflow'),
	    'description' => esc_html__('Menu List.', 'startflow'),
	    'base' => 'menulist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'background',
				'value' => '#f5f5f5',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'startflow'),
				'param_name' => 'border_color',
				'value' => '#b2b2b2',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'startflow'),
				'param_name' => 'border_width',
				'value' => '1px 0px 1px 0px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'startflow' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'startflow'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 10px 20px 10px 20px', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'startflow'),
				'param_name' => 'bottom_margin',
				'value' => '10',
	        ),
	        // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'startflow'),
				'param_name' => 'text_content',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'startflow'),
				'param_name' => 'text',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'startflow'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'startflow'),
				'param_name' => 'value_content',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Value', 'startflow'),
				'param_name' => 'value',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'startflow'),
				'param_name' => 'value_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'startflow'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'startflow' ),
				'param_name' => 'text_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'startflow' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'startflow'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'startflow'),
				'param_name' => 'value_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Family', 'startflow' ),
				'param_name' => 'value_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Weight', 'startflow' ),
				'param_name' => 'value_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Value: Font Size', 'startflow'),
				'param_name' => 'value_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// Icon Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon Box', 'startflow' ),
        'description' => esc_html__('Displaying Icon Box with custom icon.', 'startflow'),
		'base'        => 'iconbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
					'Icon Left 2' => 'icon-left2',
				),
				'std'		=> 'icon-top',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'startflow' ),
				'param_name' => 'text_align',
				'value'      => array(
					'Left' => 'align-left',
					'Center' => 'align-center',
					'Right' => 'align-right',
				),
				'std'		=> 'align-left',
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'startflow' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'startflow'),
				'param_name' => 'wrap_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'startflow'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background', 'startflow'),
				'param_name' => 'wrap_background',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Rounded', 'startflow'),
				'param_name' => 'wrap_rounded',
				'value' => '',
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Border Color', 'startflow'),
				'param_name' => 'wrap_border',
				'value' => '#e7e7e7',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Border Width', 'startflow'),
				'param_name' => 'wrap_border_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 1px', 'startflow'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap Border Style', 'startflow' ),
				'param_name' => 'wrap_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'startflow'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'startflow'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 100px', 'startflow'),
				'group' => esc_html__( 'Image', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'startflow' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'startflow' ),
				'value' => array(
					esc_html__( '', 'startflow' ) => '',
					esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
					esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
					esc_html__( 'FontAwesome', 'startflow' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
					esc_html__( 'Typicons', 'startflow' ) => 'typicons',
					esc_html__( 'Entypo', 'startflow' ) => 'entypo',
					esc_html__( 'Linecons', 'startflow' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon2',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon2',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon2',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_fontawesome',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'startflow'),
				'param_name' => 'icon_font_size',
				'value' => '30px',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Width', 'startflow'),
				'param_name' => 'icon_width',
				'value' => '60',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Height', 'startflow'),
				'param_name' => 'icon_height',
				'value' => '60',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line Height', 'startflow'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Rounded', 'startflow'),
				'param_name' => 'icon_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'startflow'),
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'startflow'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background', 'startflow'),
				'param_name' => 'icon_background',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Border Color', 'startflow'),
				'param_name' => 'icon_border',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Border Width', 'startflow'),
				'param_name' => 'icon_border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'startflow'),
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Border Style', 'startflow' ),
				'param_name' => 'icon_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'startflow'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background: Hover', 'startflow'),
				'param_name' => 'icon_background_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Border: Hover', 'startflow'),
				'param_name' => 'icon_border_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
			// Icon Shadow
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Icon Shadow', 'startflow' ),
				'param_name'  => 'icon_inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'startflow'),
				'param_name' => 'icon_horizontal',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'startflow'),
				'param_name' => 'icon_vertical',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'startflow'),
				'param_name' => 'icon_blur',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'startflow'),
				'param_name' => 'icon_spread',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'startflow'),
				'param_name' => 'icon_shadow_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
			// Content
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading URL (Optional):', 'startflow'),
				'param_name' => 'heading_url',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Description', 'startflow'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'startflow'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'startflow' ),
            ),
			// Button or Link
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Link or Button?', 'startflow' ),
				'param_name' => 'show_url',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'group' => esc_html__( 'URL', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'url_style',
				'value'      => array(
					'Link' => 'link',
					'Button' => 'button',
				),
				'std'		=> 'link',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Link Style', 'startflow' ),
				'param_name' => 'link_style',
				'value'      => array(
					'Style 1' => 'link-style-1',
					'Style 2' => 'link-style-2',
				),
				'std'		=> 'link-style-1',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Link Color', 'startflow'),
				'param_name' => 'link_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'link' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text (Required)', 'startflow'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'startflow' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'startflow'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'startflow'),
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'startflow'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'startflow'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'startflow'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'startflow' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'startflow'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'startflow'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'startflow'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'startflow'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'startflow'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'startflow' ),
				'param_name' => 'desc_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'startflow' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'startflow'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'startflow'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'startflow'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'startflow' ),
				'param_name' => 'button_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'startflow' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'startflow'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'startflow'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'startflow'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array( 'icon-left', 'icon-right' ) ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Left Padding', 'startflow'),
				'param_name' => 'content_left_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'startflow' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Right Padding', 'startflow'),
				'param_name' => 'content_right_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'startflow' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-right' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Left Margin', 'startflow'),
				'param_name' => 'heading_left_margin',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'startflow' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left2' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'startflow'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'startflow'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'startflow'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'startflow'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        // Hover
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hover Style', 'startflow' ),
				'param_name' => 'hover_style',
				'value'      => array(
					'No' => '',
					'Light' => 'hover-style-1',
					'Dark' => 'hover-style-2',
					'Accent' => 'hover-style-3',
				),
				'std'		=> '',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'bg_color',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
				'dependency' => array( 'element' => 'hover_style', 'value' => array( 'hover-style-1', 'hover-style-2' ) ),
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'startflow'),
				'param_name' => 'bg_image',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
				'dependency' => array( 'element' => 'hover_style', 'value' => array( 'hover-style-1', 'hover-style-2' ) ),
			),
		)
	) );
} );


// Iconbox Group
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_iconboxs extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Iconbox Group', 'startflow' ),
        'description' => esc_html__('Displaying Iconbox Group', 'startflow'),
		'base'        => 'iconboxs',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'iconbox' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Items', 'startflow' ),
				'param_name'  => 'style',
				'value'       => array(
					'2' 	   => '2',
					'3'        => '3',
					'4'        => '4',
				),
				'std'		=> '3',
			),
		)
	) );
} );

// Icon List
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon List', 'startflow' ),
        'description' => esc_html__('Displaying Icon Box in group.', 'startflow'),
		'base'        => 'iconlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Style', 'startflow' ),
				'param_name'  => 'style',
				'value'       => array(
					'Style 1' 	   => 'style-1',
					'Style 2'        => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item Spacing', 'startflow'),
				'param_name' => 'item_spacing',
				'value' => '',
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Line?', 'startflow' ),
				'param_name' => 'show_line',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line Style', 'startflow' ),
				'param_name' => 'line_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'dashed',
				'dependency' => array( 'element' => 'show_line', 'value' => 'yes' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'startflow'),
				'param_name' => 'line_color',
				'value' => '',
				'dependency' => array( 'element' => 'show_line', 'value' => 'yes' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'startflow'),
				'param_name' => 'line_width',
				'value' => '',
				'dependency' => array( 'element' => 'show_line', 'value' => 'yes' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Offset', 'startflow'),
				'param_name' => 'line_offset',
				'value' => '',
				'description'	=> esc_html__('Default: 30px', 'startflow'),
				'dependency' => array( 'element' => 'show_line', 'value' => 'yes' ),
	        ),
            // params group
            array(
				'type' => 'param_group',
				'heading' => 'Icon Box',
				'value' => '',
				'param_name' => 'boxicon',
				'group' => esc_html__( 'Icon Box', 'startflow' ),
				'params' => array(
		            array(
						'type' => 'textarea',
						'holder' => 'div',
						'heading' => esc_html__('Heading', 'startflow'),
						'param_name' => 'heading',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Heading Color', 'startflow'),
						'param_name' => 'heading_color',
						'value' => '',
		            ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Heading Margin', 'startflow'),
						'param_name' => 'heading_margin',
						'value' => '',
			        ),
					array(
						'type' => 'textarea',
						'holder' => 'div',
						'heading' => esc_html__( 'Description', 'startflow' ),
						'param_name' => 'description',
					),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Description Color', 'startflow'),
						'param_name' => 'desc_color',
						'value' => '',
		            ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Description Margin', 'startflow'),
						'param_name' => 'desc_margin',
						'value' => '',
			        ),
					// Icon
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Icon library', 'startflow' ),
						'param_name' => 'icon_type',
						'description' => esc_html__( 'Select icon library.', 'startflow' ),
						'value' => array(
							esc_html__( '', 'startflow' ) => '',
							esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
							esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
							esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
							esc_html__( 'Typicons', 'startflow' ) => 'typicons',
							esc_html__( 'Entypo', 'startflow' ) => 'entypo',
							esc_html__( 'Linecons', 'startflow' ) => 'linecons',
						),
					),
					array(
					    'type' => 'iconpicker',
					    'heading' => esc_html__( 'Icon', 'startflow' ),
					    'param_name' => 'icon_extraicon',
					    'settings' => array(
					        'emptyIcon' => true,
					        'type' => 'extraicon',
					        'iconsPerPage' => 200,
					    ),
					    'dependency' => array(
					        'element' => 'icon_type',
					        'value' => 'extraicon',
					    ),
					),
					array(
					    'type' => 'iconpicker',
					    'heading' => esc_html__( 'Icon', 'startflow' ),
					    'param_name' => 'icon_extraicon2',
					    'settings' => array(
					        'emptyIcon' => true,
					        'type' => 'extraicon2',
					        'iconsPerPage' => 200,
					    ),
					    'dependency' => array(
					        'element' => 'icon_type',
					        'value' => 'extraicon2',
					    ),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'startflow' ),
						'param_name' => 'icon_openiconic',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'openiconic',
							'iconsPerPage' => 200,
						),
						'dependency' => array(
							'element' => 'icon_type',
							'value' => 'openiconic',
						),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'startflow' ),
						'param_name' => 'icon_typicons',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'typicons',
							'iconsPerPage' => 200,
						),
						'dependency' => array(
							'element' => 'icon_type',
							'value' => 'typicons',
						),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'startflow' ),
						'param_name' => 'icon_entypo',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'entypo',
							'iconsPerPage' => 300,
						),
						'dependency' => array(
							'element' => 'icon_type',
							'value' => 'entypo',
						),
					),
					array(
						'type' => 'iconpicker',
						'heading' => esc_html__( 'Icon', 'startflow' ),
						'param_name' => 'icon_linecons',
						'settings' => array(
							'emptyIcon' => true,
							'type' => 'linecons',
							'iconsPerPage' => 200,
						),
						'dependency' => array(
							'element' => 'icon_type',
							'value' => 'linecons',
						),
					),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Icon Font Size', 'startflow'),
						'param_name' => 'icon_font_size',
						'value' => '30px',
			        ),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Icon Width', 'startflow'),
						'param_name' => 'icon_width',
						'value' => '60px',
		            ),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Icon Height', 'startflow'),
						'param_name' => 'icon_height',
						'value' => '60px',
		            ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Icon Line Height', 'startflow'),
						'param_name' => 'icon_line_height',
						'value' => '',
			        ),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Icon Rounded', 'startflow'),
						'param_name' => 'icon_rounded',
						'value' => '',
						'description'	=> esc_html__('ex: 10px', 'startflow'),
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Icon Color', 'startflow'),
						'param_name' => 'icon_color',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Icon Background', 'startflow'),
						'param_name' => 'icon_background',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Icon Border Color', 'startflow'),
						'param_name' => 'icon_border',
						'value' => '',
		            ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Icon Border Width', 'startflow'),
						'param_name' => 'icon_border_width',
						'value' => '',
						'description'	=> esc_html__('Default: 1px', 'startflow'),
			        ),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Icon Border Style', 'startflow' ),
						'param_name' => 'icon_border_style',
						'value'      => array(
							'Solid' => 'solid',
							'Dotted' => 'dotted',
							'Dashed' => 'dashed'
						),
						'std'		=> 'solid',
					),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Icon Color: Hover', 'startflow'),
						'param_name' => 'icon_color_hover',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Icon Background: Hover', 'startflow'),
						'param_name' => 'icon_background_hover',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Icon Border: Hover', 'startflow'),
						'param_name' => 'icon_border_hover',
						'value' => '',
		            ),
				)                
            ),
		)
	) );
} );

// Step Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Step Box', 'startflow' ),
        'description' => esc_html__('Displaying Step Box.', 'startflow'),
		'base'        => 'stepbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
            // params group
            array(
				'type' => 'param_group',
				'heading' => 'Number Box',
				'value' => '',
				'param_name' => 'numberbox',
				'group' => esc_html__( 'Number Box', 'startflow' ),
				'params' => array(
					// Icon
					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Icon library', 'startflow' ),
						'param_name' => 'icon_type',
						'description' => esc_html__( 'Select icon library.', 'startflow' ),
						'value' => array(
							esc_html__( '', 'startflow' ) => '',
							esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
							esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
						),
					),
					array(
					    'type' => 'iconpicker',
					    'heading' => esc_html__( 'Icon', 'startflow' ),
					    'param_name' => 'icon_extraicon',
					    'settings' => array(
					        'emptyIcon' => true,
					        'type' => 'extraicon',
					        'iconsPerPage' => 200,
					    ),
					    'dependency' => array(
					        'element' => 'icon_type',
					        'value' => 'extraicon',
					    ),
					),
					array(
					    'type' => 'iconpicker',
					    'heading' => esc_html__( 'Icon', 'startflow' ),
					    'param_name' => 'icon_extraicon2',
					    'settings' => array(
					        'emptyIcon' => true,
					        'type' => 'extraicon2',
					        'iconsPerPage' => 200,
					    ),
					    'dependency' => array(
					        'element' => 'icon_type',
					        'value' => 'extraicon2',
					    ),
					),


		            array(
						'type' => 'textarea',
						'holder' => 'div',
						'heading' => esc_html__('Heading', 'startflow'),
						'param_name' => 'heading',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Heading Color', 'startflow'),
						'param_name' => 'heading_color',
						'value' => '',
		            ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Heading Margin', 'startflow'),
						'param_name' => 'heading_margin',
						'value' => '',
			        ),
					array(
						'type' => 'textarea',
						'holder' => 'div',
						'heading' => esc_html__( 'Description', 'startflow' ),
						'param_name' => 'description',
					),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Description Color', 'startflow'),
						'param_name' => 'desc_color',
						'value' => '',
		            ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Description Margin', 'startflow'),
						'param_name' => 'desc_margin',
						'value' => '',
			        ),
				)                
            ),
		)
	) );
} );

// PriceTable
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Price Table', 'startflow' ),
        'description' => esc_html__('Displaying Price Tables.', 'startflow'),
		'base'        => 'pricetable',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'startflow'),
				'param_name' => 'padding',
				'value' => '',
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'bg_color',
				'value' => '',
            ),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'startflow'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'startflow' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'startflow' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Size', 'startflow' ),
				'param_name'  => 'bg_size',
				'value'       => array(
					'Auto' 	   => '',
					'Cover'        => 'cover',
				),
				'std'		=> '',
			),
			// Heading
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Heading', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'startflow' ),
            ),
			// Price
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Price', 'startflow'),
				'param_name' => 'price',
				'value' => '199',
				'group' => esc_html__( 'Price', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Color', 'startflow'),
				'param_name' => 'price_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'startflow' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Currency', 'startflow' ),
				'param_name' => 'currency',
				'value' => '$',
				'group' => esc_html__( 'Price', 'startflow' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Currency Color', 'startflow'),
				'param_name' => 'currency_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'startflow' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Unit', 'startflow' ),
				'param_name' => 'unit',
				'value' => '/MO',
				'group' => esc_html__( 'Price', 'startflow' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Unit Color', 'startflow'),
				'param_name' => 'unit_color',
				'value' => '',
				'group' => esc_html__( 'Price', 'startflow' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Content', 'startflow'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'startflow' ),
			),
			// Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text (Required)', 'startflow'),
				'param_name' => 'link_text',
				'value' => 'Sign Up',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'startflow' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'startflow'),
				'param_name' => 'button_rounded',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'startflow'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'startflow'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border Color', 'startflow'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Border Width', 'startflow'),
				'param_name' => 'button_border_width',
				'value' => '1px',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Border Style', 'startflow' ),
				'param_name' => 'button_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'startflow'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'startflow'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'startflow'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'startflow' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),      
			array(
				'type' => 'headings',
				'text' => esc_html__('Price', 'startflow'),
				'param_name' => 'price_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Family', 'startflow' ),
				'param_name' => 'price_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Price Font Weight', 'startflow' ),
				'param_name' => 'price_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Font Size', 'startflow'),
				'param_name' => 'price_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Line-Height', 'startflow'),
				'param_name' => 'price_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Unit', 'startflow'),
				'param_name' => 'unit_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Family', 'startflow' ),
				'param_name' => 'unit_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Unit Font Weight', 'startflow' ),
				'param_name' => 'unit_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Unit Font Size', 'startflow'),
				'param_name' => 'unit_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'startflow'),
				'param_name' => 'unit_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Margin', 'startflow'),
				'param_name' => 'heading_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Margin', 'startflow'),
				'param_name' => 'price_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Margin', 'startflow'),
				'param_name' => 'content_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Margin', 'startflow'),
				'param_name' => 'button_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
		)
	) );
} );

// Content Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_contentbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Content Box', 'startflow'),
		'description' => esc_html__('Content Box.', 'startflow'),
		'base' => 'contentbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'contentbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'startflow'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'startflow' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'startflow' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Size', 'startflow' ),
				'param_name'  => 'bg_size',
				'value'       => array(
					'Auto' 	   => '',
					'Cover'        => 'cover',
				),
				'std'		=> '',
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            // Spacing
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'center',
				),
				'std'		=> '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'startflow'),
				'param_name' => 'width',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'description'	=> esc_html__('Ex: 600px', 'startflow'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width on mobile', 'startflow'),
				'param_name' => 'mobile_width',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'description'	=> esc_html__('Ex: 400px', 'startflow'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'startflow'),
				'param_name' => 'height',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'description'	=> esc_html__('Ex: 400px', 'startflow'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'startflow'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'startflow'),
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding on mobile', 'startflow'),
				'param_name' => 'mobile_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'startflow'),
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'startflow'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin on mobile', 'startflow'),
				'param_name' => 'mobile_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ), 
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'startflow'),
	        ),
            // Design
			array(
				'type' => 'headings',
				'text' => esc_html__('Background', 'startflow'),
				'param_name' => 'heading_background',
				'group' => esc_html__( 'Design', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Border', 'startflow'),
				'param_name' => 'heading_border',
				'group' => esc_html__( 'Design', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'startflow'),
				'param_name' => 'border_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'startflow'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'startflow'),
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'heading_rounded',
				'group' => esc_html__( 'Design', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'startflow'),
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'startflow'),
				'param_name' => 'heading_shadow',
				'group' => esc_html__( 'Design', 'startflow' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'startflow' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Design', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'startflow'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'startflow'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'startflow'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'startflow'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'startflow'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
	        // Hover
			array(
				'type' => 'headings',
				'text' => esc_html__('Background', 'startflow'),
				'param_name' => 'heading_background_hover',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Border', 'startflow'),
				'param_name' => 'heading_border_hover',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'startflow'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'startflow'),
				'param_name' => 'border_width_hover',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'startflow'),
				'group' => esc_html__( 'Hover', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'heading_rounded_hover',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'rounded_hover',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'startflow'),
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'startflow'),
				'param_name' => 'heading_shadow_hover',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'startflow' ),
				'param_name'  => 'inset_hover',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'startflow'),
				'param_name' => 'horizontal_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'startflow'),
				'param_name' => 'vertical_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'startflow'),
				'param_name' => 'blur_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'startflow'),
				'param_name' => 'spread_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'startflow'),
				'param_name' => 'shadow_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Transforms', 'startflow'),
				'param_name' => 'heading_transforms',
				'group' => esc_html__( 'Hover', 'startflow' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Translate X', 'startflow'),
				'param_name' => 'translatex',
				'value' => 0,
				'suffix' => 'px',
				'group' => esc_html__( 'Hover', 'startflow' ),
		  	),
			array(
				'type' => 'number',
				'heading' => esc_html__('Translate Y', 'startflow'),
				'param_name' => 'translatey',
				'value' => 0,
				'suffix' => 'px',
				'group' => esc_html__( 'Hover', 'startflow' ),
		  	),
        )
    ) );
} );

// Advanced Text
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Advanced Text', 'startflow' ),
        'description' => esc_html__('Displaying a text with some styles.', 'startflow'),
		'base'        => 'advtext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'DIV' => 'div'
				),
				'std'		=> 'h2',
			),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Content', 'startflow'),
				'param_name' 	=> 'content',
				'value' 		=> '',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'startflow'),
				'param_name' => 'color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Max-Width', 'startflow'),
				'param_name' => 'max_width',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'startflow'),
				'param_name' => 'bottom_margin',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'startflow' ),
				'param_name' => 'font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'startflow' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'startflow'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'startflow'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// Single Heading
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Single Heading', 'startflow' ),
        'description' => esc_html__('Displaying a single heading with some styles.', 'startflow'),
		'base'        => 'singleheading',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'startflow' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'startflow'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'startflow'),
				'param_name' => 'line_width',
				'value' => '40',
				'group' => esc_html__( 'Line', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'startflow'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Line', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'startflow'),
				'param_name' => 'line_color',
				'value' => '#1292ee',
				'group' => esc_html__( 'Line', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing Between', 'startflow'),
				'param_name' => 'heading_padding',
				'value' => '',
				'group' => esc_html__( 'Line', 'startflow' ),
				'description'	=> esc_html__('Spacing between the line and the text. Ex: 50px.', 'startflow'),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Offset Top', 'startflow'),
				'param_name' => 'line_top',
				'value' => '',
				'group' => esc_html__( 'Line', 'startflow' ),
				'description'	=> esc_html__('Ex: 5px.', 'startflow'),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
		)
	) );
} );

// Headings
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Headings', 'startflow' ),
        'description' => esc_html__('Displaying awesome heading styles.', 'startflow'),
		'base'        => 'headings',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'startflow' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'startflow'),
				'param_name' => 'heading_width',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'startflow' ),
				'param_name' => 'subheading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'startflow'),
				'param_name' => 'subheading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'startflow'),
				'param_name' => 'subheading_width',
				'value' => '',
            ),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Extra Content', 'startflow'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Extra Content', 'startflow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Extra Content Max-Width', 'startflow'),
				'param_name' => 'content_width',
				'value' => '',
				'group' => esc_html__( 'Extra Content', 'startflow' ),
            ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'startflow' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator Position', 'startflow' ),
				'param_name' => 'sep_position',
				'value'      => array(
					'Top' => 'top',
					'Between Heading & Sub-Heading' => 'between',
					'Bottom' => 'bottom',
					'Left' => 'left',
				),
				'std'		=> 'between',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'separator', 'value' => array( 'line', 'image' ) ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'startflow'),
				'param_name' => 'line_width',
				'value' => '70',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'startflow'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Right Margin', 'startflow'),
				'param_name' => 'line_right_margin',
				'value' => '20',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'sep_position', 'value' => 'left' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'startflow'),
				'param_name' => 'line_color',
				'value' => '#1292ee',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'startflow'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'startflow'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'startflow' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size on Mobile', 'startflow'),
				'param_name' => 'heading_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'startflow'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'startflow' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'startflow' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'startflow'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'startflow'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Style', 'startflow' ),
				'param_name' => 'subheading_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'startflow'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'startflow'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Top Margin', 'startflow'),
				'param_name' => 'subheading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Bottom Margin', 'startflow'),
				'param_name' => 'subheading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
		)
	) );
} );

// Animation Block
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_animationblock extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Animation Block', 'startflow'),
		'description' => esc_html__('Apply animations anywhere.', 'startflow'),
		'base' => 'animationblock',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'animationblock'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
         )
    ) );
} );

// Counter
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Counter', 'startflow' ),
        'description' => esc_html__('Displaying a counter.', 'startflow'),
		'base'        => 'counter',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
				'dependency' => array( 'element' => 'style', 'value' => array('style-1')  ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Left Width', 'startflow'),
				'param_name' => 'left_width',
				'value' => 50,
				'suffix' => '%',
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3')  ),
		  	),
			array(
				'type' => 'number',
				'heading' => esc_html__('Right Width', 'startflow'),
				'param_name' => 'right_width',
				'value' => 50,
				'suffix' => '%',
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3')  ),
		  	),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'startflow' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'startflow' ),
				'value' => array(
					esc_html__( '', 'startflow' ) => '',
					esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
					esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
					esc_html__( 'FontAwesome', 'startflow' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
					esc_html__( 'Typicons', 'startflow' ) => 'typicons',
					esc_html__( 'Entypo', 'startflow' ) => 'entypo',
					esc_html__( 'Linecons', 'startflow' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon2',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon2',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon2',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon3',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon3',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon3',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'startflow'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'startflow'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-Height', 'startflow'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
			// Number
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number Tag', 'startflow' ),
				'param_name' => 'number_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Number', 'startflow' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Number', 'startflow' ),
				'param_name' => 'number',
				'group' => esc_html__( 'Number', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'startflow'),
				'param_name' => 'number_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'startflow' ),
            ),
			array(
				'type' => 'number',
				'heading' => esc_html__('Rolling Time', 'startflow'),
				'param_name' => 'time',
				'value' => 5000,
				'suffix' => 'ms',
				'group' => esc_html__( 'Number', 'startflow' ),
		  	),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Prefix (Optional)', 'startflow' ),
				'param_name' => 'number_prefix',
				'group' => esc_html__( 'Number', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Color', 'startflow'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'startflow' ),
            ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Suffix (Optional)', 'startflow' ),
				'param_name' => 'number_suffix',
				'group' => esc_html__( 'Number', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Color', 'startflow'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'startflow' ),
            ),
		  	// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'startflow' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'div',
				'group' => esc_html__( 'Heading', 'startflow' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading', 'startflow' ),
				'param_name' => 'heading',
				'group' => esc_html__( 'Heading', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'startflow'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'startflow'),
				'param_name' => 'heading_max_width',
				'value' => '',
				'group' => esc_html__( 'Heading', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-3') ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number Settings', 'startflow'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Family', 'startflow' ),
				'param_name' => 'number_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Weight', 'startflow' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size', 'startflow'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size on Mobile', 'startflow'),
				'param_name' => 'number_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Line Height', 'startflow'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Letter Spacing', 'startflow'),
				'param_name' => 'number_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading Settings', 'startflow'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'startflow' ),
				'param_name' => 'heading_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'startflow' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'startflow'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'startflow'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Letter Spacing', 'startflow'),
				'param_name' => 'heading_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'startflow'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Margin', 'startflow'),
				'param_name' => 'icon_right_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1','style-2') ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Top Margin', 'startflow'),
				'param_name' => 'number_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Right Margin', 'startflow'),
				'param_name' => 'number_right_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Bottom Margin', 'startflow'),
				'param_name' => 'number_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'startflow'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'startflow'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
		)
	) );
} );

// Video Icon
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Video Icon', 'startflow' ),
        'description' => esc_html__('Displaying Icon with custom video popup.', 'startflow'),
		'base'        => 'videoicon',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'White' => 'white',
					'Accent' => 'accent',
					'Green' => 'green',
				),
				'std'		=> 'white',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'startflow' ),
				'param_name' => 'size',
				'value'      => array(
					'Big' => 'big',
					'Small' => 'small',
				),
				'std'		=> 'big',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'startflow'),
				'param_name' => 'video_url',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
		)
	) );
} );

// Simple Image
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Simple Image', 'startflow' ),
        'description' => esc_html__('Displaying a simple image with animation.', 'startflow'),
		'base'        => 'simpleimage',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'startflow'),
				'param_name' => 'image',
				'value' => '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Rounded', 'startflow'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'startflow'),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
				'dependency' => array( 'element' => 'style', 'value' => 'style-1' ),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'startflow'),
				'param_name' => 'url',
				'value' => '',
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Video Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'White' => 'white',
					'Accent' => 'accent',
				),
				'std'		=> 'white',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'startflow' ),
				'param_name' => 'icon_size',
				'value'      => array(
					'Big' => 'big',
					'Small' => 'small',
				),
				'std'		=> 'big',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'startflow'),
				'param_name' => 'video_url',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'startflow'),
				'param_name' => 'heading_position',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Top', 'startflow'),
				'param_name' => 'img_top',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Right', 'startflow'),
				'param_name' => 'img_right',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom', 'startflow'),
				'param_name' => 'img_bottom',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Left', 'startflow'),
				'param_name' => 'img_left',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),

	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Translate X', 'startflow'),
				'param_name' => 'image_x',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Translate Y', 'startflow'),
				'param_name' => 'image_y',
				'value' => '',
				'group' => esc_html__( 'Video Icon', 'startflow' ),
	        ),




		)
	) );
} );

// Parallax Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_parallaxbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Parallax Box', 'startflow'),
		'description' => esc_html__('Parallax Box.', 'startflow'),
		'base' => 'parallaxbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'parallaxbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
	        array(
	            "type" => "dropdown",
	            "heading" => esc_html__('Top Padding', 'startflow'),
	            "param_name" => "top_padding",
	            'value' => array(
	                esc_html__( 'Default', 'startflow' ) => '',
	                '-250px' => '-250px',
	                '-240px' => '-240px',
	                '-230px' => '-230px',
	                '-220px' => '-220px',
	                '-210px' => '-210px',
	                '-200px' => '-200px',
	                '-190px' => '-190px',
	                '-180px' => '-180px',
	                '-170px' => '-170px',
	                '-160px' => '-160px',
	                '-150px' => '-150px',
	                '-140px' => '-140px',
	                '-130px' => '-130px',
	                '-120px' => '-120px',
	                '-110px' => '-110px',
	                '-100px' => '-100px',
	                '-90px' => '-90px',
	                '-80px' => '-80px',
	                '-70px' => '-70px',
	                '-60px' => '-60px',
	                '-50px' => '-50px',
	                '-40px' => '-40px',
	                '-30px' => '-30px',
	                '30px' => '30px',
	                '40px' => '40px',
	                '50px' => '50px',
	                '60px' => '60px',
	                '70px' => '70px',
	                '80px' => '80px',
	                '90px' => '90px',
	                '100px' => '100px',
	                '110px' => '110px',
	                '120px' => '120px',
	                '130px' => '130px',
	                '140px' => '140px',
	                '150px' => '150px',
	                '160px' => '160px',
	                '170px' => '170px',
	                '180px' => '180px',
	                '190px' => '190px',
	                '200px' => '200px',
	                '210px' => '210px',
	                '220px' => '220px',
	                '230px' => '230px',
	                '240px' => '240px',
	                '250px' => '250px',
	            ),     
	        ),
	        array(
	            "type" => "dropdown",
	            "heading" => esc_html__('Left Padding', 'startflow'),
	            "param_name" => "left_padding",
	            'value' => array(
	                esc_html__( 'Default', 'startflow' ) => '',
	                '-250px' => '-250px',
	                '-240px' => '-240px',
	                '-230px' => '-230px',
	                '-220px' => '-220px',
	                '-210px' => '-210px',
	                '-200px' => '-200px',
	                '-190px' => '-190px',
	                '-180px' => '-180px',
	                '-170px' => '-170px',
	                '-160px' => '-160px',
	                '-150px' => '-150px',
	                '-140px' => '-140px',
	                '-130px' => '-130px',
	                '-120px' => '-120px',
	                '-110px' => '-110px',
	                '-100px' => '-100px',
	                '-90px' => '-90px',
	                '-80px' => '-80px',
	                '-70px' => '-70px',
	                '-60px' => '-60px',
	                '-50px' => '-50px',
	                '50px' => '50px',
	                '60px' => '60px',
	                '70px' => '70px',
	                '80px' => '80px',
	                '90px' => '90px',
	                '100px' => '100px',
	                '110px' => '110px',
	                '120px' => '120px',
	                '130px' => '130px',
	                '140px' => '140px',
	                '150px' => '150px',
	                '160px' => '160px',
	                '170px' => '170px',
	                '180px' => '180px',
	                '190px' => '190px',
	                '200px' => '200px',
	                '210px' => '210px',
	                '220px' => '220px',
	                '230px' => '230px',
	                '240px' => '240px',
	                '250px' => '250px',
	            ),     
	        ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Parallax X', 'startflow'),
	            'param_name' => 'parallax_x',
	            'description'   => esc_html__('X axis translation.', 'startflow'),
	        ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Parallax Y', 'startflow'),
	            'param_name' => 'parallax_y',
	            'description'   => esc_html__('Y axis translation.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Max Width', 'startflow'),
				'param_name' => 'width',
				'value' => '',
				'description'	=> esc_html__('You can use % or px value. Ex: 50%.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'startflow'),
				'param_name' => 'margin',
				'value' => '',
	        ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Link URL', 'startflow' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Link URL', 'startflow' ),
			),
        )
    ) );
} );

// Icons
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icons', 'startflow' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'startflow'),
		'base'        => 'icons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'startflow' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'startflow' ),
				'value' => array(
					esc_html__( '', 'startflow' ) => '',
					esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
					esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
					esc_html__( 'FontAwesome', 'startflow' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
					esc_html__( 'Typicons', 'startflow' ) => 'typicons',
					esc_html__( 'Entypo', 'startflow' ) => 'entypo',
					esc_html__( 'Linecons', 'startflow' ) => 'linecons',
				),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon2',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon2',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon2',
			    ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_fontawesome',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'startflow'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'startflow'),
				'param_name' => 'width',
				'value' => '60',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'startflow'),
				'param_name' => 'height',
				'value' => '60',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'startflow'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'startflow'),
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'startflow'),
				'param_name' => 'color',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'startflow'),
				'param_name' => 'border_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'startflow'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'startflow'),
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'startflow' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Design', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'startflow'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Design', 'startflow' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color: Hover', 'startflow'),
				'param_name' => 'color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color: Hover', 'startflow'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color: Hover', 'startflow'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'startflow' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'startflow' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
		)
	) );
} );

// Divider
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Divider', 'startflow'),
        'description' => esc_html__('Displaying lines separator.', 'startflow'),
        'base' => 'divider',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'divider-left',
					'Center' => 'divider-center',
					'Right' => 'divider-right',
				),
				'std'		=> 'divider-center',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'no-icon' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Width', 'startflow'),
				'param_name' => 'width',
				'value' => '',
				'description' => esc_html__( 'Default: 100%.', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Height', 'startflow'),
				'param_name' => 'height',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'startflow'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line: Color', 'startflow'),
				'param_name' => 'color',
				'value' => '',
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'startflow' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Font' => 'icon-font',
				),
				'std'		=> 'no-icon',
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'startflow' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'startflow' ),
				'value' => array(
					esc_html__( '', 'startflow' ) => '',
					esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
					esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
					esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
					esc_html__( 'Typicons', 'startflow' ) => 'typicons',
					esc_html__( 'Entypo', 'startflow' ) => 'entypo',
					esc_html__( 'Linecons', 'startflow' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon2',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon2',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon2',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'startflow'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'startflow'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Padding', 'startflow'),
				'param_name' => 'icon_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'description'	=> esc_html__('Top Right Bottom Left. Default: 0px 12px 0px 12px', 'startflow'),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'startflow'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Top Margin', 'startflow'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Bottom Margin', 'startflow'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
	        ),
        )
    ) );
} );

// Alignment Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_alignbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Alignment Box', 'startflow' ),
        'description' => esc_html__('Align elements.', 'startflow'),
		'base'        => 'alignbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'alignbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide on Mobile?', 'startflow' ),
				'param_name' => 'mobi_hide',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
		)
	) );
} );

// Grid Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_gridbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Grid Box', 'startflow'),
		'description' => esc_html__('Grid Box.', 'startflow'),
		'base' => 'gridbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'gridbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Grid', 'startflow' ),
				'param_name' => 'grid',
				'value'      => array(
					'Grid 4' => '4',
					'Grid 3' => '3',
					'Grid 2' => '2',
				),
				'std'		=> '3',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Type?', 'startflow' ),
				'param_name' => 'border_type',
				'value' => array(
					'Separator' => 'separator',
					'Wrap' => 'wrap',
					'No Border' => 'no',
				),
				'std'		=> 'separator',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Color', 'startflow' ),
				'param_name' => 'border_color',
				'value' => array(
					'Light' => 'light',
					'Dark' => 'dark',
					'Very Light' => 'verylight',
				),
				'std'		=> 'light',
				'dependency' => array( 'element' => 'border_type', 'value' => array('separator', 'wrap') ),
			),
			array(
				'type'       => 'dropdown',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gapv',
				'value'      => array(
					'0' => '0',
					'5' => '5',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
				),
				'std'		=> '30',
				'dependency' => array( 'element' => 'border_type', 'value' => 'no' ),
			),
			array(
				'type'       => 'dropdown',
				'heading' => esc_html__('Spacing below items', 'startflow'),
				'param_name' => 'gaph',
				'value'      => array(
					'0' => '0',
					'5' => '5',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'60' => '60',
				),
				'std'		=> '15',
				'dependency' => array( 'element' => 'border_type', 'value' => 'no' ),
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Buttons
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Buttons', 'startflow'),
        'description' => esc_html__('Advanced Buttons.', 'startflow'),
        'base' => 'buttons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'startflow'),
				'param_name' => 'text',
				'value' => 'Button Text',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'startflow' ),
				'param_name' => 'size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'startflow'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'startflow'),
				'param_name' => 'background_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'startflow'),
				'param_name' => 'border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'startflow'),
				'param_name' => 'border_width',
				'value' => '1px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'startflow' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'startflow'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'startflow'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'startflow'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 40px 13px 40px', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'startflow'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'startflow'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Full-width Button?', 'startflow' ),
				'param_name' => 'full_width',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'startflow'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'startflow'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'startflow'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Hover
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color: Hover', 'startflow'),
				'param_name' => 'text_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color: Hover', 'startflow'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color: Hover', 'startflow'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'startflow'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'startflow' ),
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'startflow' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'No Icon' => 'no_icon',
					'Icon Style 1' => 'icon_style_1',
					'Icon Style 2' => 'icon_style_2',
					'Custom Icon' => 'custom',
				),
				'std'		=> 'no_icon',
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'startflow' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'startflow' ),
				'value' => array(
					esc_html__( '', 'startflow' ) => '',
					esc_html__( 'Elegant Icons', 'startflow' ) => 'extraicon',
					esc_html__( 'Stroke 7 Icons', 'startflow' ) => 'extraicon2',
					esc_html__( 'FontAwesome', 'startflow' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'startflow' ) => 'openiconic',
					esc_html__( 'Typicons', 'startflow' ) => 'typicons',
					esc_html__( 'Entypo', 'startflow' ) => 'entypo',
					esc_html__( 'Linecons', 'startflow' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'startflow' ),
			    'param_name' => 'icon_extraicon2',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon2',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon2',
			    ),
			    'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'startflow' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'startflow' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'startflow'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'startflow'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'startflow' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-right',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Padding', 'startflow'),
				'param_name' => 'icon_right_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'startflow'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Left Padding', 'startflow'),
				'param_name' => 'icon_left_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'startflow'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-right' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon: Offset', 'startflow' ),
				'param_name' => 'icon_offset',
				'value'      => array(
					'-15px' => '-15',
					'-14px' => '-14',
					'-13px' => '-13',
					'-12px' => '-12',
					'-11px' => '-11',
					'-10px' => '-10',
					'-9px' => '-9',
					'-8px' => '-8',
					'-7px' => '-7',
					'-6px' => '-6',
					'-5px' => '-5',
					'-4px' => '-4',
					'-3px' => '-3',
					'-2px' => '-2',
					'-1px' => '-1',
					'0px' => '0',
					'1px' => '1',
					'2px' => '2',
					'3px' => '3',
					'4px' => '4',
					'5px' => '5',
					'6px' => '6',
					'7px' => '7',
					'8px' => '8',
					'9px' => '9',
					'10px' => '10',
					'11px' => '11',
					'12px' => '12',
					'13px' => '13',
					'14px' => '14',
					'15px' => '15',
				),
				'std'		=> '0',
				'group' => esc_html__( 'Icon', 'startflow' ),
				'description'	=> esc_html__('Use this to change the distance middle the icon and top of button.', 'startflow'),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'startflow'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'startflow' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'startflow' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'startflow' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
			// Box Shadow
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'startflow'),
				'param_name' => 'heading_shadow',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'startflow' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'startflow'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'startflow'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'startflow'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'startflow'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'startflow'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'startflow' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'startflow' ),
				'param_name' => 'font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'startflow' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'startflow'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'startflow'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
        )
    ) );
} );

// Hero Section
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_hero extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Hero Section', 'startflow'),
        'description' => esc_html__('Hero Section.', 'startflow'),
        'base' => 'hero',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'hero'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hero Height', 'startflow' ),
				'param_name' => 'hero_height',
				'value'      => array(
					'Full Screen' => 'full-height',
					'Custom Height' => 'custom-height',
				),
				'std'		=> 'full-height',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Hero Custom Height', 'startflow'),
				'param_name' => 'hero_custom_height',
				'value' => '',
				'description'	=> esc_html__('Ex: 600px.', 'startflow'),
				'dependency' => array( 'element' => 'hero_height', 'value' => 'custom-height' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'startflow' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Background Slideshow' => 'slideshow',
					'Background Video' => 'video',
				),
				'std'		=> 'slideshow',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Background Images', 'startflow'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for background slideshow.', 'startflow'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Effects', 'startflow' ),
				'param_name' => 'effect',
				'value'      => array(
					'fade' => 'fade',
					'fade2' => 'fade2',
					'slideLeft' => 'slideLeft',
					'slideLeft2' => 'slideLeft2',
					'slideRight' => 'slideRight',
					'slideRight2' => 'slideRight2',
					'slideUp' => 'slideUp',
					'slideDown' => 'slideDown',
					'slideDown2' => 'slideDown2',
					'zoomIn' => 'zoomIn',
					'zoomIn2' => 'zoomIn2',
					'zoomOut' => 'zoomOut',
					'zoomOut2' => 'zoomOut2',
					'swirlLeft' => 'swirlLeft',
					'swirlLeft2' => 'swirlLeft2',
					'swirlRight' => 'swirlRight',
					'swirlRight2' => 'swirlRight2',
					'burn' => 'burn',
					'burn2' => 'burn2',
					'blur' => 'blur',
					'blur2' => 'blur2',
					'flash' => 'flash',
					'flash2' => 'flash2'
				),
				'std'		=> 'fade',
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Youtube link (URL)', 'startflow'),
				'param_name' => 'video_link',
				'value' => '',
				'description' => esc_html__('Youtube link or ID. Ex: https://www.youtube.com/watch?v=vQqZIFCab9o', 'startflow'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'video' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Pattern Overlay', 'startflow' ),
				'param_name' => 'pattern_overlay',
				'value'      => array(
					'No Parttern' => '',
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
					'Style 5' => 'style-5',
					'Style 6' => 'style-6',
					'Style 7' => 'style-7',
					'Style 8' => 'style-8',
					'Style 9' => 'style-9',
				),
				'std'		=> 'style-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color Overlay', 'startflow'),
				'param_name' => 'color_overlay',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Top Margin', 'startflow'),
				'param_name' => 'content_top',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px. In case you want to set a spacing above the content area.', 'startflow'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Content area into Grid?', 'startflow' ),
				'param_name' => 'grid',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			// Arrow
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show arrow?', 'startflow' ),
				'param_name' => 'scroll',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
				'group' => esc_html__( 'Arrow', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'startflow' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Arrow', 'startflow' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Scroll to Row (ID)', 'startflow'),
				'param_name' => 'scroll_id',
				'value' => '',
				'description' => esc_html__('Enter the anchor ID you assigned to the element.', 'startflow'),
				'group' => esc_html__( 'Arrow', 'startflow' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Images Slider or Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Slider or Grid', 'startflow' ),
		'description' => esc_html__('Displaying images in slider, masonry or mosaic grid.', 'startflow'),
		'base' => 'imagesgrid',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Layout', 'startflow' ),
				'param_name' => 'mode',
				'value'      => array(
					'Slider' => 'slider',
					'Masonry' => 'grid',
					'Masonry' => 'mosaic',
				),
				'std'		=> 'slider',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
				),
				'std'		=> 'square',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'startflow'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Images Grid.', 'startflow')
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Rounded', 'startflow'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'startflow'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gapv',
				'value' => '0',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'startflow'),
				'param_name' => 'gaph',
				'value' => '0',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px.', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Column Options', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px.', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Column Options', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px.', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Column Options', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px.', 'startflow' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Column Options', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// Images Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Carousel', 'startflow' ),
		'description' => esc_html__('Displaying images in carousel.', 'startflow'),
		'base' => 'imagescarousel',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'startflow' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
				),
				'std'		=> 'full',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'startflow'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Images Grid.', 'startflow')
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Border?', 'startflow' ),
				'param_name' => 'show_borders',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'startflow' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'startflow'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'startflow'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'startflow' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// Scroll Target
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Scroll to ID Target', 'startflow' ),
        'description' => esc_html__('Displaying a arrow for scrolling down when clicked.', 'startflow'),
		'base'        => 'scrolltarget',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
		'params'      => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('ID Target', 'startflow'),
				'param_name' => 'id_target',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'startflow'),
				'param_name' => 'color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Size', 'startflow'),
				'param_name' => 'size',
				'value' => '',
	        ),
		)
	) );
} );

// Special Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Special Text', 'startflow'),
        'description' => esc_html__('Awesome Texts.', 'startflow'),
        'base' => 'specialtext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'Div' => 'div',
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'div',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 1 (Optional)', 'startflow' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 2 (Optional)', 'startflow' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 3 (Optional)', 'startflow' ),
				'param_name' => 'text3',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 1 Color', 'startflow'),
				'param_name' => 'color1',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 2 Color', 'startflow'),
				'param_name' => 'color2',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 3 Color', 'startflow'),
				'param_name' => 'color3',
				'value' => '',
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 1', 'startflow'),
				'param_name' => 'text1_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Family', 'startflow' ),
				'param_name' => 'text1_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Weight', 'startflow' ),
				'param_name' => 'text1_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Font Size', 'startflow'),
				'param_name' => 'text1_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Style', 'startflow' ),
				'param_name' => 'text1_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 2', 'startflow'),
				'param_name' => 'text2_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Family', 'startflow' ),
				'param_name' => 'text2_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Weight', 'startflow' ),
				'param_name' => 'text2_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Font Size', 'startflow'),
				'param_name' => 'text2_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Style', 'startflow' ),
				'param_name' => 'text2_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 3', 'startflow'),
				'param_name' => 'text3_typograpy',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Family', 'startflow' ),
				'param_name' => 'text3_font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Weight', 'startflow' ),
				'param_name' => 'text3_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 3: Font Size', 'startflow'),
				'param_name' => 'text3_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'startflow' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Style', 'startflow' ),
				'param_name' => 'text3_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			// Spacing
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Right Padding', 'startflow'),
				'param_name' => 'text1_right_padding',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Right Padding', 'startflow'),
				'param_name' => 'text2_right_padding',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'startflow' ),
            ),
        )
    ) );
} );

// Fancy Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Fancy Text', 'startflow'),
        'description' => esc_html__('Awesome Animation Text.', 'startflow'),
        'base' => 'fancytext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'startflow' ),
				'param_name' => 'animation',
				'value'      => array(
					'Scrolling' => 'scroll',
					'Typing' => 'typed',
				),
				'std'		=> 'scroll',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 1 (Optional)', 'startflow' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 2 (Optional)', 'startflow' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 3 (Optional)', 'startflow' ),
				'param_name' => 'text3',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 4 (Optional)', 'startflow' ),
				'param_name' => 'text4',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 5 (Optional)', 'startflow' ),
				'param_name' => 'text5',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix Text (Optional)', 'startflow' ),
				'param_name' => 'prefix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'startflow' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix Text (Optional)', 'startflow' ),
				'param_name' => 'suffix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'startflow' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'startflow'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Text Color', 'startflow'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'startflow' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Text Color', 'startflow'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'startflow' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'startflow' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'startflow' ),
				'param_name' => 'font_family',
				'value'      =>  startflow_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'startflow' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'startflow' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Max', 'startflow' ),
				'param_name' => 'font_max',
				'value' => 70,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'startflow' ),
				'description'	=> esc_html__('Important! This size only appear exactly on the full-width grid, 65px max-size on the 1170 grid and 32px max-size on the 570px grid.', 'startflow'),
		  	),
		  	array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Min', 'startflow' ),
				'param_name' => 'font_min',
				'value' => 22,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'startflow' ),
		  	),
        )
    ) );
} );

// Partner Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Partner Carousel', 'startflow'),
	    'description' => esc_html__('Displaying partner posts in carousel.', 'startflow'),
	    'base' => 'partners',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'startflow'),
	    'params' => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Border?', 'startflow' ),
				'param_name' => 'show_border',
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'startflow'),
				'param_name' => 'gap',
				'value' => '10',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'startflow' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'startflow'),
			),
			// Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'startflow'),
				'param_name' => 'items',
				'value' => '5',
				'group' => esc_html__( 'Query', 'startflow' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'startflow'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Only show posts from specific category-slug (optional).', 'startflow'),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'startflow' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'startflow' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
	    )
	) );
} );

// Subscribe Form
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Subscribe Form', 'startflow'),
        'description' => esc_html__('Displaying mailchimp newsletter form.', 'startflow'),
        'base' => 'subscribe',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'startflow' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'startflow' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Max-Width', 'startflow'),
				'param_name' => 'width',
				'value' => '',
            ),
        )
    ) );
} );

// Google Maps
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Google Maps', 'startflow'),
        'description' => esc_html__('Displaying Google Maps.', 'startflow'),
        'base' => 'googlemap',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Latitude', 'startflow' ),
				'param_name'  => 'lat',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'startflow').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'startflow'),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Longitude', 'startflow' ),
				'param_name'  => 'lng',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'startflow').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'startflow'),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Width', 'startflow' ),
				'param_name' => 'width',
				'value'      => ''
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Height', 'startflow' ),
				'param_name' => 'height',
				'value'      => 300
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Zoom Level', 'startflow' ),
				'param_name'  => 'zoom',
				'description' => esc_html__( 'Select the default zoom level for the Maps', 'startflow' ),
				'value'       => array_combine( range( 1, 24 ), range( 1, 24 ) ),
				'std'		  => '14'
			),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Mobile' ),
                'param_name' => 'drag_mobile',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Desktop' ),
                'param_name' => 'drag_desktop',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Show The Marker', 'startflow' ),
				'param_name'  => 'marker_type',
				'value'       => array(
					'Simple'          => 'simple',
					'Custom Image' => 'image',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Maker', 'startflow' ),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'startflow'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Maker', 'startflow' ),
				'dependency' => array( 'element' => 'marker_type', 'value' => 'image' ),
			),
        )
    ) );
} );

// Products Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Products Carousel', 'startflow'),
        'description' => esc_html__('Displaying products in carousel.', 'startflow'),
        'base' => 'dproducts',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'startflow'),
				'param_name' => 'number',
				'value' => '4',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('The number of campaigns to show.', 'startflow'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'startflow'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'startflow' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'startflow'),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'startflow' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'startflow'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'startflow' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'startflow' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'startflow' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'startflow'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'startflow' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'startflow' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array( esc_html__( 'Yes, please.', 'startflow' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'startflow' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'startflow' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'startflow' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'startflow' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'startflow' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'startflow' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'startflow' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Countdown
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('CountDown', 'startflow'),
        'description' => esc_html__('Displaying Countdown Timer.', 'startflow'),
        'base' => 'countdown',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'startflow'),
        'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Time', 'startflow' ),
				'param_name' => 'time',
				'value' => 'December 30, 2020 8:30:00'
			),
        )
    ) );
} );