<?php
if ( ! defined('ABSPATH') ) {
	die('Please do not load this file directly!');
}

add_action('init', 'register_testimonials_post_type');
/**
  * Register testimonials post type
*/
function register_testimonials_post_type() {
    $testimonials_slug = 'testimonials';

    $labels = array(
        'name'               => esc_html__( 'Testimonials', 'startflow' ),
        'singular_name'      => esc_html__( 'Testimonials Item', 'startflow' ),
        'add_new'            => esc_html__( 'Add New', 'startflow' ),
        'add_new_item'       => esc_html__( 'Add New Item', 'startflow' ),
        'new_item'           => esc_html__( 'New Item', 'startflow' ),
        'edit_item'          => esc_html__( 'Edit Item', 'startflow' ),
        'view_item'          => esc_html__( 'View Item', 'startflow' ),
        'all_items'          => esc_html__( 'All Items', 'startflow' ),
        'search_items'       => esc_html__( 'Search Items', 'startflow' ),
        'parent_item_colon'  => esc_html__( 'Parent Items:', 'startflow' ),
        'not_found'          => esc_html__( 'No items found.', 'startflow' ),
        'not_found_in_trash' => esc_html__( 'No items found in Trash.', 'startflow' )
    );

    $args = array(
        'labels'        => $labels,
        'rewrite'       => array( 'slug' => $testimonials_slug ),
        'supports'      => array( 'title', 'thumbnail' ),
        'public'        => true
    );

    register_post_type( 'testimonials', $args );
}

add_filter( 'post_updated_messages', 'testimonials_updated_messages' );
/**
  * Testimonials update messages.
*/
function testimonials_updated_messages( $messages ) {
    $post             = get_post();
    $post_type        = get_post_type( $post );
    $post_type_object = get_post_type_object( $post_type );

    $messages['testimonials'] = array(
        0  => '', // Unused. Messages start at index 1.
        1  => esc_html__( 'Testimonials updated.', 'startflow' ),
        2  => esc_html__( 'Custom field updated.', 'startflow' ),
        3  => esc_html__( 'Custom field deleted.', 'startflow' ),
        4  => esc_html__( 'Testimonials updated.', 'startflow' ),
        5  => isset( $_GET['revision'] ) ? sprintf( esc_html__( 'Testimonials restored to revision from %s', 'startflow' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6  => esc_html__( 'Testimonials published.', 'startflow' ),
        7  => esc_html__( 'Testimonials saved.', 'startflow' ),
        8  => esc_html__( 'Testimonials submitted.', 'startflow' ),
        9  => sprintf(
            esc_html__( 'Testimonials scheduled for: <strong>%1$s</strong>.', 'startflow' ),
            date_i18n( esc_html__( 'M j, Y @ G:i', 'startflow' ), strtotime( $post->post_date ) )
        ),
        10 => esc_html__( 'Testimonials draft updated.', 'startflow' )
    );
    return $messages;
}

add_action( 'init', 'register_testimonials_taxonomy' );
/**
  * Register testimonials taxonomy
*/
function register_testimonials_taxonomy() {
    $cat_slug = 'testimonials_category';

    $labels = array(
        'name'                       => esc_html__( 'Testimonials Categories', 'startflow' ),
        'singular_name'              => esc_html__( 'Category', 'startflow' ),
        'search_items'               => esc_html__( 'Search Categories', 'startflow' ),
        'menu_name'                  => esc_html__( 'Categories', 'startflow' ),
        'all_items'                  => esc_html__( 'All Categories', 'startflow' ),
        'parent_item'                => esc_html__( 'Parent Category', 'startflow' ),
        'parent_item_colon'          => esc_html__( 'Parent Category:', 'startflow' ),
        'new_item_name'              => esc_html__( 'New Category Name', 'startflow' ),
        'add_new_item'               => esc_html__( 'Add New Category', 'startflow' ),
        'edit_item'                  => esc_html__( 'Edit Category', 'startflow' ),
        'update_item'                => esc_html__( 'Update Category', 'startflow' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'startflow' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'startflow' ),
        'not_found'                  => esc_html__( 'No Category found.', 'startflow' ),
        'menu_name'                  => esc_html__( 'Categories', 'startflow' ),
    );
    $args = array(
        'labels'        => $labels,
        'rewrite'             => array('slug'=>$cat_slug),
        'hierarchical'  => true,
    );
    register_taxonomy( 'testimonials_category', 'testimonials', $args );
}