<?php
get_header();

$pre_title = startflow_get_mod( 'related_pre_title', 'Related Projects' );
$title = startflow_get_mod( 'related_title', 'Our work — digital marketing case studies' );
$related_query = startflow_get_mod( 'project_related_query', '7' );
$related_column = startflow_get_mod( 'project_related_column', '3' );
$related_item_gap = startflow_get_mod( 'project_related_item_spacing', '30' );

$terms = get_the_terms( $post->ID, 'project_category' );
$term_ids = wp_list_pluck( $terms, 'term_id' );
?>
<div class="project-detail-wrap">
	<?php
	while ( have_posts() ) : the_post();
		the_content();
	endwhile; ?>
</div>

<?php if ( startflow_get_mod( 'project_related', true )  ): ?>
<div class="project-related-wrap">
		<div class="startflow-container">
		<div class="clearfix">
			<div class="title-wrap">
				<div class="pre-title"><?php echo esc_html( $pre_title ); ?></div>
				<h2 class="title"><?php echo esc_html( $title ); ?></h2>
			</div>
		</div>
		<?php
		$query_args = array(
			'post_type' => 'project',
			'tax_query' => array(
				array(
				'taxonomy' => 'project_category',
				'field' => 'term_id',
				'terms' => $term_ids,
				'operator'=> 'IN'
				)),
			'ignore_sticky_posts' => 1,
			'post__not_in'=> array( $post->ID )
		);

		$query_args['posts_per_page'] = $related_query;
		$query = new WP_Query( $query_args );
		if ( $query->have_posts() ) :
			$terms = wp_get_post_terms( get_the_ID(), 'project_category' ); ?>

			<div class="project-related" data-gap="<?php echo esc_html( $related_item_gap ); ?>" data-column="<?php echo esc_html( $related_column ); ?>">
				<div class="owl-carousel owl-theme">
					<?php while ( $query->have_posts() ) : $query->the_post(); ?>
					<?php wp_enqueue_script( 'startflow-owlcarousel' ); ?>

					<div class="project-box">
						<?php
							$hover_text = $title_html = $hover_text_html = '';

			            	$title = startflow_metabox( 'title' ) ? startflow_metabox( 'title' ) : get_the_title();
			            	$title_html = sprintf('<h4 class="title"><a href="%1$s" title="%2$s">%2$s</a></h4>', esc_url( get_the_permalink() ), esc_attr( $title ) );

							echo '<div class="project-wrap"><div class="project-image"><div class="inner">'. get_the_post_thumbnail( get_the_ID(), 'startflow-rectangle9' ) .'<div class="project-text">'. $title_html .'</div></div></div></div>';
						?>
					</div><!-- /.project-box -->
					<?php endwhile; ?>
				</div><!-- /.owl-carousel -->
			</div><!-- /.project-related -->
		<?php
		endif; wp_reset_postdata();
		?>
	</div><!-- /.startflow-container -->
</div><!-- /.project-related-wrap -->
<?php endif; ?>

<?php get_footer(); ?>