<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div class="mobi-overlay"><span class="close"></span></div>
<div id="wrapper" style="<?php echo startflow_element_bg_css( 'wrapper_background_img' ); ?>">
	<?php 
	if ( startflow_get_mod( 'header_search_icon', false ) )
		echo startflow_header_search(); ?>
	
    <div id="page" class="clearfix <?php echo startflow_preloader_class(); ?>">
    	<div id="site-header-wrap">
			<!-- Top Bar -->
		    <?php get_template_part( 'templates/top'); ?>
		    
			<!-- Header -->
			<header id="site-header" style="<?php echo startflow_header_style(); ?>">
	            <div id="site-header-inner" class="startflow-container">
	            	<div class="wrap-inner">
				        <?php
				        // Get Header logo
				        get_template_part( 'templates/header-logo' );

				        // Get Header aside
				        get_template_part( 'templates/header-aside' ); ?>
			        </div>
	            </div><!-- /#site-header-inner -->

	            <?php
	            // For Header 5 & 6
	            get_template_part( 'templates/header-bottom' ); ?>
			</header><!-- /#site-header -->
		</div><!-- /#site-header-wrap -->

		<?php get_template_part( 'templates/featured-title'); ?>

        <!-- Main Content -->
        <div id="main-content" class="site-main clearfix" style="<?php echo startflow_main_content_bg(); ?>">