<?php
/**
 * Metabox Options
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Return the registered-widget array
function startflow_get_widget_registered() {
	global $wp_registered_sidebars;

	$widgets_areas = array();
	if ( ! empty( $wp_registered_sidebars ) ) {
		foreach ( $wp_registered_sidebars as $widget_area ) {
			$name = isset ( $widget_area['name'] ) ? $widget_area['name'] : '';
			$id = isset ( $widget_area['id'] ) ? $widget_area['id'] : '';
			if ( $name && $id ) {
				$widgets_areas[$id] = $name;
			}
		}
	}

	return $widgets_areas;
}

// Return the all-widget array
function startflow_get_widget_mods() {
	$new_arr = array();
	$widget_areas_mod = startflow_get_mod( 'widget_areas' );
	
	if (is_array($widget_areas_mod) || is_object($widget_areas_mod)) {
		foreach( $widget_areas_mod as $key ) {
			$new_arr[sanitize_key($key)] = $key;
		}
	}
	
	$widget_areas = startflow_get_widget_registered() + $new_arr;

	return $widget_areas;
}

// Registering meta boxes. Using Meta Box plugin: https://metabox.io/
function startflow_register_meta_boxes( $meta_boxes ) {
	// Element Thumbnail
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Element Thumbnail', 'startflow' ),
		'id'     => 'opt-meta-box-element-thumbnail',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Image', 'startflow' ),
				'id'   => 'element_thumbnail',
				'type' => 'image_advanced',
				'max_file_uploads' => 1
			),
		),
	);
	// Post Format Gallery
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Post Format: Gallery', 'startflow' ),
		'id'     => 'opt-meta-box-post-format-gallery',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Images', 'startflow' ),
				'id'   => 'gallery_images',
				'type' => 'image_advanced',
			),
		),
	);

	// Post Format Video
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Post Format: Video ( Embeded video from youtube, vimeo...)', 'startflow' ),
		'id'     => 'opt-meta-box-post-format-video',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Video URL or Embeded Code', 'startflow' ),
				'id'   => 'video_url',
				'type' => 'textarea',
			),
		)
	);

	// Partner
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Partner Settings', 'startflow' ),
		'id'     => 'opt-meta-box-partner',
		'pages'  => array( 'partner' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Hyperlink', 'startflow' ),
				'id'   => 'partner_hyperlink',
				'type'       => 'text',
				'desc'  => esc_html__( "Partne's URL. Leave blank to disable (please 'http://' included).", 'startflow' )
			),
		)
	);

	// Portfolio
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Project Settings', 'startflow' ),
		'id'     => 'opt-meta-box-project',
		'pages'  => array( 'project' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Title', 'startflow' ),
				'id'   => 'title',
				'type' => 'textarea',
			),
			array(
				'name' => esc_html__( 'Description', 'startflow' ),
				'id'   => 'desc',
				'type' => 'textarea',
			),
			array(
				'name'    => esc_html__( 'Image Cropping', 'startflow' ),
				'id'      => 'image_crop',
				'type'    => 'select',
				'options' => array(
					'full' => esc_html__( 'Full', 'startflow' ),
					'square' => esc_html__( '770 x 770', 'startflow' ),
					'rectangle' => esc_html__( '770 x 385', 'startflow' ),
					'rectangle1' => esc_html__( '770 x 850', 'startflow' ),
					'rectangle2' => esc_html__( '770 x 700', 'startflow' ),
					'rectangle3' => esc_html__( '640 x 480', 'startflow' ),
					'rectangle4' => esc_html__( '640 x 400', 'startflow' ),
					'rectangle5' => esc_html__( '600 x 400', 'startflow' ),
					'rectangle6' => esc_html__( '370 x 630', 'startflow' ),
					'rectangle7' => esc_html__( '370 x 370', 'startflow' ),
					'rectangle8' => esc_html__( '385 x 385', 'startflow' ),
					'rectangle9' => esc_html__( '370 x 300', 'startflow' ),
					'rectangle10' => esc_html__( '370 x 500', 'startflow' ),
				),
				'std'     => 'full',
			),
		)
	);

	// Member
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Member Information', 'startflow' ),
		'id'     => 'opt-meta-box-pages',
		'pages'  => array( 'member' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Name', 'startflow' ),
				'id'   => 'name',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Position', 'startflow' ),
				'id'   => 'position',
				'type'       => 'textarea',
			),
			array(
				'name' => esc_html__( 'Text', 'startflow' ),
				'id'   => 'text',
				'type'       => 'textarea',
			),
			array(
				'name' => esc_html__( 'Facebook', 'startflow' ),
				'id'   => 'facebook',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Twitter', 'startflow' ),
				'id'   => 'twitter',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Linkedin', 'startflow' ),
				'id'   => 'linkedin',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Google +', 'startflow' ),
				'id'   => 'google_plus',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Instagram', 'startflow' ),
				'id'   => 'instagram',
				'type'       => 'text',
			),
		)
	);

	// Testimonials
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Testimonials Information', 'startflow' ),
		'id'     => 'opt-meta-box-pages',
		'pages'  => array( 'testimonials' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Name', 'startflow' ),
				'id'   => 'name',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Position', 'startflow' ),
				'id'   => 'position',
				'type'       => 'text',
			),
			array(
				'name' => esc_html__( 'Text', 'startflow' ),
				'id'   => 'text',
				'type' => 'textarea',
			),
		)
	);

	// Top Bar Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Top-Bar Settings', 'startflow' ),
		'id'     => 'opt-meta-box-top-bar',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name'    => esc_html__( 'Style', 'startflow' ),
				'id'      => 'top_bar_style',
				'type'    => 'select',
				'options' => array(
					'hide' => esc_html__( 'Hide', 'startflow' ),
					'style-1' => esc_html__( 'Dark-Text', 'startflow' ),
					'style-2' => esc_html__( 'Light-Text', 'startflow' ),
				),
				'std'     => 'hide',
			),
			array(
			    'name'	=> esc_html__( 'Background', 'startflow' ),
			    'id'	=> 'top_bar_background',
			    'type'	=> 'color',
			    'alpha_channel' => true,
			    'js_options'    => array(
			        'palettes' => array( '#000000', '#ffffff', '#dd3333', '#dd9933', '#eeee22', '#81d742', '#1e73be', '#8224e3' )
			    ),
			),
			array(
				'name' => esc_html__( 'Border Width', 'startflow' ),
				'id'   => 'top_bar_border_width',
				'type' => 'text',
				'desc'    => esc_html__( 'Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'startflow' )
			),
			array(
			    'name'	=> esc_html__( 'Border Color', 'startflow' ),
			    'id'	=> 'top_bar_border_color',
			    'type'	=> 'color',
			    'alpha_channel' => true,
			    'js_options'    => array(
			        'palettes' => array( '#000000', '#ffffff', '#dd3333', '#dd9933', '#eeee22', '#81d742', '#1e73be', '#8224e3' )
			    ),
			),
		)
	);

	// Header Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Header Settings', 'startflow' ),
		'id'     => 'opt-meta-box-header',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name'    => esc_html__( 'Style', 'startflow' ),
				'id'      => 'header_style',
				'type'    => 'select',
				'options' => array(
					'style-1' => esc_html__( 'Dark-Text', 'startflow' ),
					'style-2' => esc_html__( 'Light-Text', 'startflow' ),
					'style-3' => esc_html__( 'Transparent Dark-Text', 'startflow' ),
					'style-4' => esc_html__( 'Transparent Light-Text', 'startflow' ),
					'style-5' => esc_html__( 'Accent Aside', 'startflow' ),
					'style-6' => esc_html__( 'Dark Aside', 'startflow' ),
				),
				'std'     => 'style-1',
			),
			array(
			    'name'	=> esc_html__( 'Background', 'startflow' ),
			    'id'	=> 'header_background',
			    'type'	=> 'color',
			    'alpha_channel' => true,
			    'js_options'    => array(
			        'palettes' => array( '#000000', '#ffffff', '#dd3333', '#dd9933', '#eeee22', '#81d742', '#1e73be', '#8224e3' )
			    ),
			),
			array(
				'name' => esc_html__( 'Border Width', 'startflow' ),
				'id'   => 'header_border_width',
				'type' => 'text',
				'desc'    => esc_html__( 'Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'startflow' )
			),
			array(
			    'name'	=> esc_html__( 'Border Color', 'startflow' ),
			    'id'	=> 'header_border_color',
			    'type'	=> 'color',
			    'alpha_channel' => true,
			    'js_options'    => array(
			        'palettes' => array( '#000000', '#ffffff', '#dd3333', '#dd9933', '#eeee22', '#81d742', '#1e73be', '#8224e3' )
			    ),
			),
			array(
				'name'    => esc_html__( 'Current Menu Link', 'startflow' ),
				'id'      => 'menu_link_current',
				'type'    => 'select',
				'options' => array(
					'cur-menu-1' => esc_html__( 'Style 1', 'startflow' ),
					'cur-menu-2' => esc_html__( 'Style 2', 'startflow' ),
					'cur-menu-3' => esc_html__( 'Style 3', 'startflow' ),
					'cur-menu-4' => esc_html__( 'Style 4', 'startflow' ),
				),
				'std'     => 'cur-menu-1',
			),
			array(
				'name'    => esc_html__( 'Dropdown Menu Style', 'startflow' ),
				'id'      => 'menu_sub_style',
				'type'    => 'select',
				'options' => array(
					'sub-menu-1' => esc_html__( 'Style 1', 'startflow' ),
					'sub-menu-2' => esc_html__( 'Style 2', 'startflow' ),
				),
				'std'     => 'sub-menu-1',
			),
		)
	);

	// Featured Title Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Featured Title Settings', 'startflow' ),
		'id'     => 'opt-meta-box-featured-title',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Hide?', 'startflow' ),
				'id'   => 'hide_featured_title',
				'type' => 'checkbox',
			),
			array(
				'type'		=>	'image_advanced',
				'name'		=>	esc_html__( 'Background', 'startflow' ),
				'id'		=>	'featured_title_bg',
			    'max_file_uploads' => 1,
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Custom Title', 'startflow' ),
				'id'		=>	'custom_featured_title',
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Custom Sub-Title', 'startflow' ),
				'id'		=>	'custom_featured_subtitle',
			),
		)
	);

	// Main Content Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Main Content Settings', 'startflow' ),
		'id'     => 'opt-meta-box-main-content',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name'    => esc_html__( 'Layout Position', 'startflow' ),
				'id'      => 'page_layout',
				'type'    => 'image_select',
				'options' => array(
					'no-sidebar'  => get_template_directory_uri() . '/assets/admin/img/full-content.png',
					'sidebar-left'  => get_template_directory_uri() . '/assets/admin/img/sidebar-left.png',
					'sidebar-right' => get_template_directory_uri() . '/assets/admin/img/sidebar-right.png',
				),
				'std' 		=> 'no-sidebar',
			),
			array(
				'name'    => esc_html__( 'Sidebar', 'startflow' ),
				'id'      => 'page_sidebar',
				'type'    => 'select',
				'options' => startflow_get_widget_mods(),
				'std'     => 'sidebar-page',
				'desc'    => esc_html__( 'This option do not apply if Layout Position is full-width.', 'startflow' )
			),
			array(
				'type'		=>	'image_advanced',
				'name'		=>	esc_html__( 'Background', 'startflow' ),
				'id'		=>	'main_content_bg',
			    'max_file_uploads' => 1,
			),
			array(
				'name' => esc_html__( 'Remove: Top & Bottom Padding?', 'startflow' ),
				'id'   => 'hide_padding_content',
				'type' => 'checkbox',
			),
		)
	);

	// Footer Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Footer Settings', 'startflow' ),
		'id'     => 'opt-meta-box-footer',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Hide: Footer?', 'startflow' ),
				'id'   => 'hide_footer',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Hide: Footer Subscribe?', 'startflow' ),
				'id'   => 'hide_footer_subscribe',
				'type' => 'checkbox',
			),
			array(
			    'name'          => 'Footer Widget: Background',
			    'id'            => 'footer_bg',
			    'type'          => 'color',
			    'alpha_channel' => true,
			),
			array(
			    'name'          => 'Bottom Bar: Background',
			    'id'            => 'bottom_bg',
			    'type'          => 'color',
			    'alpha_channel' => true,
			),
			array(
				'name' => esc_html__( 'Hide: Line Footer?', 'startflow' ),
				'id'   => 'hide_line_footer',
				'type' => 'checkbox',
			),
		)
	);

	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'startflow_register_meta_boxes' );