<?php
/**
 * Shop setting for Customizer
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Main Shop
$this->sections['startflow_shop_general'] = array(
	'title' => esc_html__( 'Main Shop', 'startflow' ),
	'panel' => 'startflow_shop',
	'settings' => array(
		array(
			'id' => 'shop_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Layout Position', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'startflow' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'startflow' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'startflow' ),
				),
				'desc' => esc_html__( 'Specify layout for main shop page.', 'startflow' ),
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title',
			'default' => esc_html__( 'Our Shop', 'startflow' ),
			'control' => array(
				'label' => esc_html__( 'Shop: Featured Title', 'startflow' ),
				'type' => 'startflow_textarea',
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop: Featured Title Background', 'startflow' ),
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_products_per_page',
			'default' => 6,
			'control' => array(
				'label' => esc_html__( 'Products Per Page', 'startflow' ),
				'type' => 'number',
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Shop Columns', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_item_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Bottom Margin', 'startflow' ),
				'description' => esc_html__( 'Example: 30px.', 'startflow' ),
				'active_callback' => 'startflow_cac_has_woo',
			),
			'inline_css' => array(
				'target' => '.products li',
				'alter' => 'margin-top',
			),
		),
	),
);

// Single Shop
$this->sections['startflow_single_shop_general'] = array(
	'title' => esc_html__( 'Single Shop', 'startflow' ),
	'panel' => 'startflow_shop',
	'settings' => array(
		array(
			'id' => 'shop_single_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Single Layout Position', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'startflow' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'startflow' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'startflow' ),
				),
				'desc' => esc_html__( 'Specify layout on the shop single page.', 'startflow' ),
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title',
			'default' => esc_html__( 'Our Shop', 'startflow' ),
			'control' => array(
				'label' => esc_html__( 'Shop Single: Featured Title', 'startflow' ),
				'type' => 'text',
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop Single: Featured Title Background', 'startflow' ),
				'active_callback' => 'startflow_cac_has_woo',
			),
		),
	),
);