<?php
/**
 * Layout setting for Customizer
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Layout Style
$this->sections['startflow_layout_style'] = array(
	'title' => esc_html__( 'Layout Site', 'startflow' ),
	'panel' => 'startflow_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout Style', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','startflow' ),
					'boxed' => esc_html__( 'Boxed','startflow' )
				),
			),
		),
		array(
			'id' => 'site_layout_boxed_shadow',
			'control' => array(
				'label' => esc_html__( 'Box Shadow', 'startflow' ),
				'type' => 'checkbox',
				'active_callback' => 'startflow_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'site_layout_wrapper_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrapper Margin', 'startflow' ),
				'desc' => esc_html__( 'Top Right Bottom Left. Default: 30px 0px 30px 0px.', 'startflow' ),
				'active_callback' => 'startflow_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'wrapper_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Outer Background Color', 'startflow' ),
				'type' => 'color',
				'active_callback' => 'startflow_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wrapper_background_img',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image', 'startflow' ),
				'type' => 'image',
				'active_callback' => 'startflow_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'wrapper_background_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image Style', 'startflow' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'startflow' ),
					'cover'        => esc_html__( 'Cover', 'startflow' ),
					'center-top'        => esc_html__( 'Center Top', 'startflow' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'startflow' ),
					'fixed'        => esc_html__( 'Fixed Center', 'startflow' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'startflow' ),
					'repeat'       => esc_html__( 'Repeat', 'startflow' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'startflow' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'startflow' ),
				),
				'active_callback' => 'startflow_cac_has_boxed_layout',
			),
		),
	),
);

// Layout Position
$this->sections['startflow_layout_position'] = array(
	'title' => esc_html__( 'Layout Position', 'startflow' ),
	'panel' => 'startflow_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Site Layout Position', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'startflow' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'startflow' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'startflow' ),
				),
				'desc' => esc_html__( 'Specify layout for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'startflow' )
			),
		),
		array(
			'id' => 'single_post_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Single Post Layout Position', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'startflow' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'startflow' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'startflow' ),
				),
				'desc' => esc_html__( 'Specify layout for all single post pages.', 'startflow' )
			),
		),
	),
);

// Layout Widths
$this->sections['startflow_layout_widths'] = array(
	'title' => esc_html__( 'Layout Widths', 'startflow' ),
	'panel' => 'startflow_layout',
	'settings' => array(
		array(
			'id' => 'site_desktop_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container', 'startflow' ),
				'type' => 'text',
				'desc' => esc_html__( 'Default: 1170px', 'startflow' ),
			),
			'inline_css' => array(
				'target' => array( 
					'.site-layout-full-width .startflow-container',
					'.site-layout-boxed #page'
				),
				'alter' => 'width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content', 'startflow' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 66%', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '#site-content',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar', 'startflow' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 28%', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '#sidebar',
				'alter' => 'width',
			),
		),
	),
);