<?php
/**
 * Footer setting for Customizer
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Footer General
$this->sections['startflow_footer_general'] = array(
	'title' => esc_html__( 'General', 'startflow' ),
	'panel' => 'startflow_footer',
	'settings' => array(
		array(
			'id' => 'footer_columns',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Footer Column(s)', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'5' => '5',
					'4' => '4',
					'3' => '3',
					'2' => '2',
					'1' => '1',
				),
			),
		),
		array(
			'id' => 'footer_column_gutter',
			'default' => '30',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Footer Column Gutter', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'5'    => '5px',
					'10'   => '10px',
					'15'   => '15px',
					'20'   => '20px',
					'25'   => '25px',
					'30'   => '30px',
					'35'   => '35px',
					'40'   => '40px',
					'45'   => '45px',
					'50'   => '50px',
					'60'   => '60px',
					'70'   => '70px',
					'80'   => '80px',
				),
				'active_callback' => 'startflow_cac_has_footer_simple',
			),
		),
		array(
			'id' => 'footer_text_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '#footer-widgets .widget',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'footer_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'footer_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Top Padding', 'startflow' ),
				'description' => esc_html__( 'Example: 60px.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => 'padding-top',
			),
		),
		array(
			'id' => 'footer_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Bottom Padding', 'startflow' ),
				'description' => esc_html__( 'Example: 60px.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '#footer',
				'alter' => 'padding-bottom',
			),
		),
	),
);

// Footer Subscribe
$this->sections['startflow_footer_subscribe'] = array(
	'title' => esc_html__( 'Subscribe Block', 'startflow' ),
	'panel' => 'startflow_footer',
	'settings' => array(
		array(
			'id' => 'subscribe_box',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Enable', 'startflow' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'subscribe_heading',
			'default' => esc_html__( 'Sign up to receive advance notice of new products, special offers, discounts and promotions.', 'startflow' ),
			'control' => array(
				'label' => esc_html__( 'Heading', 'startflow' ),
				'type' => 'startflow_textarea',
				'rows' => 3,
				'active_callback' => 'startflow_cac_has_footer_subscribe',
			),
		),
		array(
			'id' => 'subscribe_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background Color', 'startflow' ),
				'active_callback' => 'startflow_cac_has_footer_subscribe',
			),
			'inline_css' => array(
				'target' => '.footer-subscribe',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'subscribe_bg_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'startflow' ),
				'active_callback' => 'startflow_cac_has_footer_subscribe',
			),
		),
		array(
			'id' => 'subscribe_bg_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'startflow' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'startflow' ),
					'cover'        => esc_html__( 'Cover', 'startflow' ),
					'center-top'        => esc_html__( 'Center Top', 'startflow' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'startflow' ),
					'fixed'        => esc_html__( 'Fixed Center', 'startflow' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'startflow' ),
					'repeat'       => esc_html__( 'Repeat', 'startflow' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'startflow' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'startflow' ),
				),
				'active_callback' => 'startflow_cac_has_footer_subscribe',
			),
		),
	),
);