<?php
/**
 * Bottom Bar setting for Customizer
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bottom Bar General
$this->sections['startflow_bottombar_general'] = array(
	'title' => esc_html__( 'General', 'startflow' ),
	'panel' => 'startflow_bottombar',
	'settings' => array(
		array(
			'id' => 'bottom_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'startflow' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'bottom_copyright',
			'transport' => 'postMessage',
			'default' => '&copy; StartFlow - Startup and Creative Multipurpose WordPress Theme. <a href="#">Terms of Use</a>',
			'control' => array(
				'label' => esc_html__( 'Copyright', 'startflow' ),
				'type' => 'startflow_textarea',
				'active_callback' => 'startflow_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_padding',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'startflow' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'startflow' ),
				'active_callback'=> 'startflow_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom .bottom-bar-inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'bottom_background',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'startflow' ),
				'active_callback'=> 'startflow_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'bottom_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'startflow' ),
				'active_callback' => 'startflow_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'startflow' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'startflow' ),
					'cover'        => esc_html__( 'Cover', 'startflow' ),
					'center-top'        => esc_html__( 'Center Top', 'startflow' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'startflow' ),
					'fixed'        => esc_html__( 'Fixed Center', 'startflow' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'startflow' ),
					'repeat'       => esc_html__( 'Repeat', 'startflow' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'startflow' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'startflow' ),
				),
				'active_callback' => 'startflow_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'startflow' ),
				'active_callback'=> 'startflow_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'line_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Line Color', 'startflow' ),
				'active_callback'=> 'startflow_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom .bottom-bar-inner-wrap:before',
				'alter' => 'background-color',
			),
		),
	),
);