<?php
/**
 * Blog setting for Customizer
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Blog Posts General
$this->sections['startflow_blog_post'] = array(
	'title' => esc_html__( 'General', 'startflow' ),
	'panel' => 'startflow_blog',
	'settings' => array(
		array(
			'id' => 'blog_featured_title',
			'default' => esc_html__( 'Our News', 'startflow' ),
			'control' => array(
				'label' => esc_html__( 'Blog Featured Title', 'startflow' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_entry_content_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Content Background Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.post-content-wrap',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'blog_entry_content_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Content Padding', 'startflow' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'blog_entry_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Bottom Margin', 'startflow' ),
				'description' => esc_html__( 'Example: 30px.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'margin-top',
			),
		),
		array(
			'id' => 'blog_entry_border_width',
			'transport' => 'postMessage',
			'control' => array (
				'type' => 'text',
				'label' => esc_html__( 'Entry Border Width', 'startflow' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0px 2px 0px 0px', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'blog_entry_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Border Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'blog_entry_composer',
			'default' => 'cat,title,meta,excerpt_content,readmore',
			'control' => array(
				'label' => esc_html__( 'Entry Content Elements', 'startflow' ),
				'type' => 'startflow-sortable',
				'object' => 'Startflow_Customize_Control_Sorter',
				'choices' => array(
					'cat'             => esc_html__( 'Category', 'startflow' ),
					'title'           => esc_html__( 'Title', 'startflow' ),
					'meta'            => esc_html__( 'Meta', 'startflow' ),
					'excerpt_content' => esc_html__( 'Excerpt', 'startflow' ),
					'readmore'        => esc_html__( 'Read More', 'startflow' ),

				),
				'desc' => esc_html__( 'Drag and drop elements to re-order.', 'startflow' ),
			),
		),
	),
);

// Blog Posts Title
$this->sections['startflow_blog_post_title'] = array(
	'title' => esc_html__( 'Blog Post - Title', 'startflow' ),
	'panel' => 'startflow_blog',
	'settings' => array(
		array(
			'id' => 'blog_title_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'startflow' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_title_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => array(
					'.hentry .post-title a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_title_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color Hover', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Meta
$this->sections['startflow_blog_post_meta'] = array(
	'title' => esc_html__( 'Blog Post - Meta', 'startflow' ),
	'panel' => 'startflow_blog',
	'settings' => array(
		array(
			'id' => 'blog_entry_meta_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Meta Margin', 'startflow' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 20px 0.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta',
				'alter' => 'margin',
			),
		),
		array(
			'id'  => 'blog_entry_meta_items',
			'default' => array( 'author', 'date' ),
			'control' => array(
				'label' => esc_html__( 'Meta Items', 'startflow' ),
				'desc' => esc_html__( 'Click and drag and drop elements to re-order them.', 'startflow' ),
				'type' => 'startflow-sortable',
				'object' => 'Startflow_Customize_Control_Sorter',
				'choices' => array(
					'author'     => esc_html__( 'Author', 'startflow' ),
					'date'       => esc_html__( 'Date', 'startflow' ),
				),
			),
		),
		array(
			'id' => 'heading_blog_entry_meta_item',
			'control' => array(
				'type' => 'startflow-heading',
				'label' => esc_html__( 'Item Meta', 'startflow' ),
			),
		),
		array(
			'id' => 'blog_entry_meta_item_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color Hover', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Excerpt
$this->sections['startflow_blog_post_excerpt'] = array(
	'title' => esc_html__( 'Blog Post - Excerpt', 'startflow' ),
	'panel' => 'startflow_blog',
	'settings' => array(
		array(
			'id' => 'blog_content_style',
			'default' => 'style-1',
			'control' => array(
				'label' => esc_html__( 'Content Style', 'startflow' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Normal', 'startflow' ),
					'style-2' => esc_html__( 'Excerpt', 'startflow' ),
				),
			),
		),
		array(
			'id' => 'blog_excerpt_length',
			'default' => '50',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'startflow' ),
				'type' => 'text',
				'desc' => esc_html__( 'This option only apply for Content Style: Excerpt.', 'startflow' )
			),
		),
		array(
			'id' => 'blog_excerpt_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'startflow' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 30px 0.', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_excerpt_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'startflow' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Read More
$this->sections['startflow_blog_post_read_more'] = array(
	'title' => esc_html__( 'Blog Post - Read More', 'startflow' ),
	'panel' => 'startflow_blog',
	'settings' => array(
		array(
			'id' => 'blog_entry_button_read_more_text',
			'default' => esc_html__( 'Read More', 'startflow' ),
			'control' => array(
				'label' => esc_html__( 'Button Text', 'startflow' ),
				'type' => 'text',
			),
		),
	),
);

