<?php
/**
 * Accent color
 *
 * @package startflow
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Start Class
if ( ! class_exists( 'Startflow_Accent_Color' ) ) {
	class Startflow_Accent_Color {
		// Main constructor
		public function __construct() {
			add_filter( 'startflow_custom_colors_css', array( 'Startflow_Accent_Color', 'generate' ), 1 );
		}

		// Generates arrays of elements to target
		private static function arrays( $return ) {
			// Color
			$texts = apply_filters( 'startflow_accent_texts', array(
				'.text-accent-color',
				'#top-bar .top-bar-content .content:before',
				'.top-bar-style-1 #top-bar .top-bar-socials .icons a:hover',
				'.top-bar-style-2 #top-bar .top-bar-socials .icons a:hover',
				'.sticky-post',
				'#site-logo .site-logo-text:hover',
				'#main-nav .sub-menu li a:hover',
				'.search-style-fullscreen .search-submit:hover:after',
				'.header-style-1 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-1 #site-header .header-search-trigger:hover',
				'.header-style-2 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-2 #site-header .header-search-trigger:hover',
				'.header-style-3 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-3 #site-header .header-search-trigger:hover',
				'.header-style-3 #site-header .header-button a',
				'.header-style-4 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-4 #site-header .header-search-trigger:hover',
				'.header-style-6 #site-header .nav-cart-trigger:hover',
				'.header-style-6 #site-header .header-search-trigger:hover',
				'.header-style-6 #main-nav > ul > li.current-menu-item > a',
				'.header-style-6 #main-nav > ul > li.current-menu-parent > a',
				'.header-style-6 #main-nav > ul > li > a:hover',
				'#header-aside .aside-content .info-i span',
				'#featured-title #breadcrumbs a:hover',
				'.hentry .page-links span',
				'.hentry .page-links a span',
				'.hentry .post-title a:hover',
				'.hentry .post-tags:before',
				'.hentry .post-tags a',
				'.hentry .post-author .author-socials .socials a ',
				'.related-news .related-title',
				'.related-news .post-item .post-categories a:hover',
				'.related-news .post-item .text-wrap h3 a:hover',
				'.related-news .related-post .slick-next:hover:before',
				'.related-news .related-post .slick-prev:hover:before',
				'.comments-area .comments-title',
				'.comments-area .comment-reply-title',
				'.comment-reply a',
				'#cancel-comment-reply-link',
				'.widget.widget_archive ul li a:hover',
				'.widget.widget_categories ul li a:hover',
				'.widget.widget_meta ul li a:hover',
				'.widget.widget_nav_menu ul li a:hover',
				'.widget.widget_pages ul li a:hover',
				'.widget.widget_recent_entries ul li a:hover',
				'.widget.widget_recent_comments ul li a:hover',
				'.widget.widget_rss ul li a:hover',
				'#footer-widgets .widget.widget_archive ul li a:hover',
				'#footer-widgets .widget.widget_categories ul li a:hover',
				'#footer-widgets .widget.widget_meta ul li a:hover',
				'#footer-widgets .widget.widget_nav_menu ul li a:hover',
				'#footer-widgets .widget.widget_pages ul li a:hover',
				'#footer-widgets .widget.widget_recent_entries ul li a:hover',
				'#footer-widgets .widget.widget_recent_comments ul li a:hover',
				'#footer-widgets .widget.widget_rss ul li a:hover',
				'#sidebar .widget.widget_calendar caption',
				'#footer-widgets .widget.widget_calendar caption',
				'#sidebar .widget .widget-title',
				'.widget.widget_nav_menu .menu > li.current-menu-item > a',
				'.widget.widget_nav_menu .menu > li.current-menu-item',
				'#sidebar .widget.widget_calendar tbody #today',
				'#sidebar .widget.widget_calendar tbody #today a',
				'#sidebar .widget_information ul li.accent-icon i',
				'#footer-widgets .widget_information ul li.accent-icon i',
				'#sidebar .widget.widget_twitter .authorstamp:before',
				'#footer-widgets .widget.widget_twitter .authorstamp:before',
				'.widget.widget_search .search-form .search-submit:before',
				'#sidebar .widget.widget_socials .socials a:hover',
				'#footer-widgets .widget.widget_socials .socials a:hover',
				'#sidebar .widget.widget_recent_posts h3 a:hover',
				'#footer-widgets .widget.widget_recent_posts h3 a:hover',
				'.startflow-pagination ul li .page-numbers',
				'.woocommerce-pagination .page-numbers li .page-numbers',
				'#bottom .bottom-bar-copyright a:hover',

				// shortcodes
				'.startflow-accordions .accordion-item .accordion-heading:hover',
				'.startflow-accordions .accordion-item .accordion-heading > .inner:before',
				'.startflow-accordions .accordion-item.style-1.active .accordion-heading',
				'.startflow-accordions .accordion-item.style-1.active .accordion-heading > .inner:before',
				'.startflow-step-box .number-box .number',
				'.startflow-links.accent',
				'.startflow-links:hover',
				'.startflow-button.outline.outline-accent',
				'.startflow-button.outline.outline-accent .icon',
				'.startflow-counter .icon.accent',
				'.startflow-counter .prefix.accent',
				'.startflow-counter .suffix.accent',
				'.startflow-counter .number.accent',
				'.startflow-divider.has-icon .icon-wrap > span.accent',
				'.startflow-single-heading .heading.accent',
				'.startflow-headings .heading.accent',
				'.startflow-icon.accent > .icon',
				'.startflow-image-box.style-1 .item .title a:hover',
				'.startflow-image-box.style-3 .item .title a:hover',
				'.startflow-news .news-item .text-wrap .categories a:hover',
				'.startflow-news .news-item .text-wrap .title a:hover',
				'.startflow-news.style-2 .news-item .text-wrap .categories a:hover',
				'.startflow-news.style-2 .news-item .text-wrap .title a:hover',
				'.startflow-news.style-2 .news-item .post-meta a:hover',
				'.project-box.style-2 .project-image > .title a:hover',
				'.project-box.style-2 .project-image > .terms a:hover',
				'.project-box.style-2 .project-image > .title a:hover',
				'.project-box.style-2 .project-image > .terms a:hover',
				'.project-box.style-3 .project-image > .title a:hover',
				'.project-box.style-3 .project-image > .terms a:hover',
				'.project-related-wrap .title-wrap .pre-title',
				'.project-related-wrap .btn-wrap a',
				'.project-related-wrap .project-item .cat a',
				'.project-related-wrap .project-item h2 a:hover',
				'.startflow-progress .perc.accent',
				'.startflow-list .icon.accent',
				'.startflow-price-table .price-name .heading.accent',
				'.startflow-price-table .price-figure .currency.accent',
				'.startflow-price-table .price-figure .figure.accent',
				'.startflow-price-table .price-figure .term',
				'.owl-theme .owl-nav [class*="owl-"]:hover:after',

				 // Woocommerce
				'.woocommerce-page .woocommerce-MyAccount-content .woocommerce-info .button',
				'.products li .product-info .button',
				'.products li .product-info .added_to_cart',
				'.products li .product-cat:hover',
				'.products li h2:hover',

				'.woo-single-post-class .woocommerce-grouped-product-list-item__label a:hover',
				'.woo-single-post-class .woocommerce-tabs .comment-respond .comment-reply-title',
				'.woocommerce-page .shop_table.cart .product-name a:hover',
				'.woocommerce-page .shop_table.cart .product-remove a:after',
				'.product_list_widget .product-title:hover',
				'.widget_recent_reviews .product_list_widget a:hover',
				'.widget_product_categories ul li a:hover',

				'.widget.widget_product_search .woocommerce-product-search .search-submit:hover:before',
				'.widget_shopping_cart_content ul li a:hover',
				'.widget_shopping_cart_content ul li a.remove',
				'.widget_shopping_cart_content .buttons a.checkout',

				 // Default Link
				 'a',
			) );

			// Background color
			$backgrounds = apply_filters( 'startflow_accent_backgrounds', array(
				'bg-accent',

				'button, input[type="button"], input[type="reset"], input[type="submit"]',
				'.tparrows.custom:hover',
				'.header-style-1 #site-header .header-button a',
				'.header-style-1 #site-header .header-button a:hover',
				'.header-style-2 #site-header .header-button a',
				'.header-style-3 #site-header .header-button a:hover',
				'.header-style-5 .site-navigation-wrap',
				'.header-style-5 #site-header .header-button a',
				'.header-style-6 #site-header .header-button a',
				'.cur-menu-4 #main-nav > ul > li.current-menu-item > a:before',
				'.cur-menu-4 #main-nav > ul > li.current-menu-parent > a:before',
				'#featured-title.center .main-title:before',
				'.post-media .slick-prev:hover',
				'.post-media .slick-next:hover',
				'.post-media .slick-dots li.slick-active button',
				'.hentry .post-link a',
				'.comment-reply a:after',
				'#cancel-comment-reply-link:after',
				'.widget.widget_categories ul li > span',
				'.widget.widget_archive ul li > span',
				'#sidebar .widget.widget_recent_posts .recent-news .thumb.icon',
				'#footer-widgets .widget.widget_recent_posts .recent-news .thumb.icon',
				'#sidebar .widget.widget_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget.widget_tag_cloud .tagcloud a:hover',
				'.widget_product_tag_cloud .tagcloud a:hover',
				'#scroll-top:hover:before',
				'.startflow-pagination ul li .page-numbers.current',
				'.woocommerce-pagination .page-numbers li .page-numbers.current',
				'.no-results-content .search-form .search-submit:before',

				// shortcodes
				'.startflow-accordions .accordion-item.style-2.active .accordion-heading',
				'.startflow-step-box .number-box:hover .number',
				'.startflow-button.accent',
				'.startflow-button.outline.outline-accent:hover',
				'.startflow-content-box > .inner.accent',
				'.startflow-content-box > .inner.dark-accent',
				'.startflow-content-box > .inner.light-accent',
				'.startflow-tabs.style-2 .tab-title .item-title.active',
				'.startflow-tabs.style-3 .tab-title .item-title.active',
				'.startflow-single-heading .line.accent',
				'.startflow-headings .sep.accent',
				'.startflow-headings .heading > span',
				'.startflow-image-box.style-3.has-number:hover .number',
				'.startflow-images-grid .cbp-nav-next:hover:after',
				'.startflow-images-grid .cbp-nav-prev:hover:after',
				'.startflow-icon.accent-bg > .icon',
				'#project-filter .cbp-filter-item > span:after',
				'.project-box .project-image > .inner:after',
				'.project-related-wrap .btn-wrap a:hover',
				'.startflow-progress .progress-animate.accent',
				'.startflow-images-carousel.has-borders:after',
				'.startflow-images-carousel.has-borders:before',
				'.startflow-images-carousel.has-arrows.arrow-bottom .owl-nav',
				'.startflow-team .socials li a:hover',
				'.startflow-team-grid .socials li a:hover',
				'.startflow-video-icon.accent a',

				// woocemmerce
				'.woocommerce-page .woo-single-post-class .summary .stock.in-stock',
				'.product .onsale',
				'.woocommerce-page .wc-proceed-to-checkout .button',
				'.woocommerce-page .return-to-shop a',
				'.woocommerce-page #payment #place_order',
				'.widget_price_filter .price_slider_amount .button:hover',
				'.widget_shopping_cart_content .buttons a.checkout',
			) );

			// Border color
			$borders = apply_filters( 'startflow_accent_borders', array(
				'.underline-solid:after, .underline-dotted:after, .underline-dashed:after' => array( 'bottom' ),
				'.header-style-3 #site-header .header-button a',
				'#sidebar .widget.widget_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget.widget_tag_cloud .tagcloud a:hover',
				'.widget_product_tag_cloud .tagcloud a:hover',
				'.widget.widget_search .search-form .search-field:focus',
				'#sidebar .mc4wp-form .email-wrap input:focus',
				'.no-results-content .search-form .search-field:focus',

				// shortcodes
				'.startflow-step-box .number-box .number',
				'.startflow-button.outline.outline-accent',
				'.startflow-button.outline.outline-accent:hover',
				'.divider-icon-before.accent',
				'.divider-icon-after.accent',
				'.startflow-divider.has-icon .divider-double.accent',
				'.startflow-tabs.style-2 .tab-title .item-title.active > span' => array( 'top' ),
				'.startflow-icon-box.hover-style-1:hover > .hover' => array( 'bottom' ),
				'.startflow-icon-box.hover-style-2:hover > .hover' => array( 'bottom' ),
				'.startflow-image-box.style-2 .item .thumb:after' => array( 'bottom' ),
				'.startflow-team.style-1 .member-item .text-wrap' => array( 'bottom' ),
				'.startflow-team.style-2 .member-item .text-wrap' => array( 'bottom' ),
				'.startflow-testimonials.style-1:hover .inner' => array( 'bottom' ),
				'.startflow-testimonials-g3 .avatar-wrap img:hover',
				'.startflow-testimonials-g3 .avatar-wrap a.active img',
				'.startflow-video-icon.white a:after' => array( 'left' ),
				'.startflow-video-icon.accent .circle',

				// woocommerce
				'.woo-single-post-class .summary .cart .quantity input',
				'.widget_price_filter .price_slider_amount .button:hover',
				'.widget_price_filter .ui-slider .ui-slider-handle',
			) );

			// Gradient color
			$gradients = apply_filters( 'startflow_accent_gradient', array(
				'.startflow-progress .progress-animate.accent.gradient'
			) );

			// Return array
			if ( 'texts' == $return ) {
				return $texts;
			} elseif ( 'backgrounds' == $return ) {
				return $backgrounds;
			} elseif ( 'borders' == $return ) {
				return $borders;
			} elseif ( 'gradients' == $return ) {
				return $gradients;
			}
		}

		// Generates the CSS output
		public static function generate( $output ) {

			// Get custom accent
			$default_accent = '#1292ee';
			$custom_accent  = startflow_get_mod( 'accent_color' );

			// Return if accent color is empty or equal to default
			if ( ! $custom_accent || ( $default_accent == $custom_accent ) )
				return $output;

			// Define css var
			$css = '';

			// Get arrays
			$texts       = self::arrays( 'texts' );
			$backgrounds = self::arrays( 'backgrounds' );
			$borders     = self::arrays( 'borders' );
			$gradients    = self::arrays( 'gradients' );

			// Texts
			if ( ! empty( $texts ) )
				$css .= implode( ',', $texts ) .'{color:'. $custom_accent .';}';

			// Backgrounds
			if ( ! empty( $backgrounds ) )
				$css .= implode( ',', $backgrounds ) .'{background-color:'. $custom_accent .';}';

			// Borders
			if ( ! empty( $borders ) ) {
				foreach ( $borders as $key => $val ) {
					if ( is_array( $val ) ) {
						$css .= $key .'{';
						foreach ( $val as $key => $val ) {
							$css .= 'border-'. $val .'-color:'. $custom_accent .';';
						}
						$css .= '}'; 
					} else {
						$css .= $val .'{border-color:'. $custom_accent .';}';
					}
				}
			}

			// Gradients
			if ( ! empty( $gradients ) )
				$css .= implode( ',', $gradients ) .'{background: '. startflow_hex2rgba($custom_accent, 1) .';background: -moz-linear-gradient(left, '. startflow_hex2rgba($custom_accent, 1) .' 0%, '. startflow_hex2rgba($custom_accent, 0.3) .' 100%);background: -webkit-linear-gradient( left, '. startflow_hex2rgba($custom_accent, 1) .' 0%, '. startflow_hex2rgba($custom_accent, 0.3) .' 100% );background: linear-gradient(to right, '. startflow_hex2rgba($custom_accent, 1) .' 0%, '. startflow_hex2rgba($custom_accent, 0.3) .' 100%) !important;}';

			// Return CSS
			if ( ! empty( $css ) )
				$output .= '/*ACCENT COLOR*/'. $css;

			// Return output css
			return $output;
		}
	}
}

new Startflow_Accent_Color();